/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane;

import android.content.Context;
import com.flarelane.BaseSharedPreferences;
import com.flarelane.FlareLane;
import com.flarelane.HTTPClient;
import com.flarelane.InAppMessage;
import com.flarelane.Notification;
import com.flarelane.Utils;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0002J*\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0007J*\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0007J(\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\bJ\u001e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bJ4\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0007R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/flarelane/EventService;", "", "()V", "unhandledClickedNotification", "Lcom/flarelane/Notification;", "create", "", "projectId", "", "deviceId", "notificationId", "type", "userId", "createBackgroundReceived", "notification", "createForegroundReceived", "createNotificationClicked", "executeInAppMessageAction", "context", "Landroid/content/Context;", "iam", "Lcom/flarelane/InAppMessage;", "actionId", "trackEvent", "data", "Lorg/json/JSONObject;", "FlareLane_release"})
public final class EventService {
    @NotNull
    public static final EventService INSTANCE = new EventService();
    @JvmField
    @Nullable
    public static Notification unhandledClickedNotification;

    private EventService() {
    }

    public final void createNotificationClicked(@NotNull String projectId, @NotNull String deviceId, @NotNull Notification notification, @Nullable String userId) throws Exception {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        this.create(projectId, deviceId, notification.id, "CLICKED", userId);
        if (FlareLane.notificationClickedHandler != null) {
            FlareLane.notificationClickedHandler.onClicked(notification);
        } else {
            unhandledClickedNotification = notification;
        }
    }

    public final void executeInAppMessageAction(@NotNull Context context, @NotNull InAppMessage iam, @NotNull String actionId) throws Exception {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)iam, (String)"iam");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        String projectId = BaseSharedPreferences.getProjectId(context, false);
        String deviceId = BaseSharedPreferences.getDeviceId(context, false);
        if (FlareLane.inAppMessageActionHandler != null) {
            FlareLane.inAppMessageActionHandler.onExecute(iam, actionId);
        }
    }

    @JvmStatic
    public static final void createBackgroundReceived(@NotNull String projectId, @NotNull String deviceId, @NotNull Notification notification, @Nullable String userId) throws Exception {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        INSTANCE.create(projectId, deviceId, notification.id, "BACKGROUND_RECEIVED", userId);
    }

    @JvmStatic
    public static final void createForegroundReceived(@NotNull String projectId, @NotNull String deviceId, @NotNull Notification notification, @Nullable String userId) throws Exception {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        INSTANCE.create(projectId, deviceId, notification.id, "FOREGROUND_RECEIVED", userId);
    }

    private final void create(String projectId, String deviceId, String notificationId, String type, String userId) throws Exception {
        JSONObject body = new JSONObject();
        body.put("notificationId", (Object)notificationId);
        body.put("deviceId", (Object)deviceId);
        body.put("platform", (Object)"android");
        body.put("type", (Object)type);
        body.put("createdAt", (Object)Utils.getISO8601DateString());
        if (userId != null) {
            body.put("userId", (Object)userId);
        }
        HTTPClient.post("internal/v1/projects/" + projectId + "/events", body, new HTTPClient.ResponseHandler());
    }

    @JvmStatic
    public static final void trackEvent(@NotNull String projectId, @NotNull String deviceId, @Nullable String userId, @NotNull String type, @Nullable JSONObject data) throws Exception {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String subjectType = userId != null ? "user" : "device";
        String string = userId;
        if (string == null) {
            string = deviceId;
        }
        String subjectId = string;
        JSONObject event = new JSONObject().put("type", (Object)type).put("subjectType", (Object)subjectType).put("subjectId", (Object)subjectId).put("createdAt", (Object)Utils.getISO8601DateString()).put("platform", (Object)"android").put("deviceId", (Object)deviceId);
        if (data != null) {
            event.put("data", (Object)data);
        }
        if (userId != null) {
            event.put("userId", (Object)userId);
        }
        JSONObject body = new JSONObject().put("events", (Object)new JSONArray().put((Object)event));
        HTTPClient.post("internal/v1/projects/" + projectId + "/events-v2", body, new HTTPClient.ResponseHandler());
    }
}

