/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane;

import android.app.ActivityManager;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.flarelane.BaseErrorHandler;
import com.flarelane.BaseSharedPreferences;
import com.flarelane.ChannelManager;
import com.flarelane.EventService;
import com.flarelane.Logger;
import com.flarelane.NotificationConvertedActivity;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import java.util.Date;
import java.util.List;
import java.util.Random;

public class MessagingService
extends FirebaseMessagingService {
    private static boolean appInForeground(@NonNull Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List runningAppProcesses = activityManager.getRunningAppProcesses();
        if (runningAppProcesses == null) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo runningAppProcess : runningAppProcesses) {
            if (!runningAppProcess.processName.equals(context.getPackageName()) || runningAppProcess.importance != 100) continue;
            return true;
        }
        return false;
    }

    public void onNewToken(String token) {
        Logger.verbose("onNewToken");
    }

    public void onMessageReceived(RemoteMessage remoteMessage) {
        try {
            super.onMessageReceived(remoteMessage);
            if (remoteMessage == null) {
                return;
            }
            boolean isForeground = MessagingService.appInForeground(this.getApplicationContext());
            Logger.verbose("onMessageReceived isForeground: " + isForeground);
            if (remoteMessage.getData().size() > 0) {
                Logger.verbose("Message data payload: " + remoteMessage.getData());
                String notificationId = (String)remoteMessage.getData().get("notificationId");
                String title = (String)remoteMessage.getData().get("title");
                String body = (String)remoteMessage.getData().get("body");
                String url = (String)remoteMessage.getData().get("url");
                String type = isForeground ? "FOREGROUND_RECEIVED" : "BACKGROUND_RECEIVED";
                String projectId = BaseSharedPreferences.getProjectId(this.getApplicationContext());
                String deviceId = BaseSharedPreferences.getDeviceId(this.getApplicationContext());
                EventService.create(projectId, deviceId, notificationId, type);
                Intent intent = new Intent(this.getApplicationContext(), NotificationConvertedActivity.class).addFlags(0x24000000).putExtra("title", title).putExtra("body", body).putExtra("url", url).putExtra("notificationId", notificationId);
                PendingIntent contentIntent = PendingIntent.getActivity((Context)this.getApplicationContext(), (int)new Random().nextInt(543254), (Intent)intent, (int)0x8000000);
                int currentIcon = this.getPackageManager().getApplicationInfo((String)this.getPackageName(), (int)128).icon;
                Context context = this.getApplicationContext();
                Notification notification = new NotificationCompat.Builder(this.getApplicationContext(), ChannelManager.getChannelId(this.getApplicationContext())).setSmallIcon(17301569).setContentText((CharSequence)body).setContentTitle((CharSequence)(title == null ? context.getApplicationInfo().loadLabel(context.getPackageManager()).toString() : title)).setAutoCancel(true).setContentIntent(contentIntent).setPriority(2).setVisibility(1).build();
                notification.defaults |= 1;
                notification.defaults |= 4;
                notification.defaults |= 2;
                NotificationManagerCompat.from((Context)this.getApplicationContext()).notify((int)new Date().getTime(), notification);
            }
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }
}

