/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane;

import com.flarelane.BaseErrorHandler;
import com.flarelane.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;

class HTTPClient {
    private static final String BASE_URL = "https://service-api.flarelane.com/";

    HTTPClient() {
    }

    public static void get(final String path, final ResponseHandler responseHandler) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                HttpURLConnection conn = null;
                try {
                    URL url = new URL(HTTPClient.BASE_URL + path);
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
                    conn.setRequestProperty("Accept", "application/json");
                    conn.setUseCaches(false);
                    HTTPClient.handleResponse(conn, responseHandler);
                }
                catch (Exception e) {
                    BaseErrorHandler.handle(e);
                }
                finally {
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
            }
        }).start();
    }

    public static void post(String path, JSONObject body, ResponseHandler responseHandler) {
        HTTPClient.sendRequestWithBody("POST", path, body, responseHandler);
    }

    public static void patch(String path, JSONObject body, ResponseHandler responseHandler) {
        HTTPClient.sendRequestWithBody("PATCH", path, body, responseHandler);
    }

    public static void delete(String path, JSONObject body, ResponseHandler responseHandler) {
        HTTPClient.sendRequestWithBody("DELETE", path, body, responseHandler);
    }

    private static void sendRequestWithBody(final String method, final String path, final JSONObject body, final ResponseHandler responseHandler) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HttpURLConnection conn = null;
                try {
                    URL url = new URL(HTTPClient.BASE_URL + path);
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setUseCaches(false);
                    conn.setDoOutput(true);
                    conn.setDoInput(true);
                    conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                    conn.setRequestProperty("Accept", "application/json");
                    conn.setRequestMethod(method);
                    if (body != null) {
                        String strJsonBody = body.toString();
                        byte[] sendBytes = strJsonBody.getBytes("UTF-8");
                        conn.setFixedLengthStreamingMode(sendBytes.length);
                        OutputStream outputStream = conn.getOutputStream();
                        outputStream.write(sendBytes);
                        Logger.verbose("HTTP " + method + " body: " + body.toString());
                    }
                    HTTPClient.handleResponse(conn, responseHandler);
                }
                catch (Exception e) {
                    BaseErrorHandler.handle(e);
                }
                finally {
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
            }
        }).start();
    }

    private static void handleResponse(HttpURLConnection conn, ResponseHandler responseHandler) throws Exception {
        int responseCode = conn.getResponseCode();
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(conn.getInputStream());
        }
        catch (FileNotFoundException e) {
            in = new BufferedInputStream(conn.getErrorStream());
        }
        String response = HTTPClient.convertStreamToString(in);
        JSONObject json = new JSONObject(response);
        switch (responseCode) {
            case 200: 
            case 201: {
                responseHandler.onSuccess(responseCode, json);
                break;
            }
            default: {
                responseHandler.onFailure(responseCode, json);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    protected static class ResponseHandler {
        protected ResponseHandler() {
        }

        void onSuccess(int responseCode, JSONObject response) {
            Logger.verbose("HTTPClient.ResponseHandler.onSuccess: " + response.toString());
        }

        void onFailure(int responseCode, JSONObject response) {
            Logger.error("HTTPClient.ResponseHandler.onFailure: " + response.toString());
        }
    }
}

