/*
 * Decompiled with CFR 0.152.
 */
package com.fingerth.supdialogutils.progressbar.round;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.fingerth.supdialogutils.R;
import com.fingerth.supdialogutils.progressbar.horizontal.HorizontalWithNumberProgressBar;
import com.fingerth.supdialogutils.utils.SupDialogStaticUtils;

public class RoundWidthNumberProgressBar
extends HorizontalWithNumberProgressBar {
    private int mRadius = SupDialogStaticUtils.dp2px(this.getContext(), 30);

    public RoundWidthNumberProgressBar(Context context) {
        this(context, null);
    }

    public RoundWidthNumberProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (this.mUnReachedProgressBarHeight > this.mReachedProgressBarHeight) {
            this.mUnReachedProgressBarHeight = this.mReachedProgressBarHeight;
        }
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.RoundWidthNumberBar);
        this.mRadius = (int)ta.getDimension(R.styleable.RoundWidthNumberBar_radius, (float)this.mRadius);
        ta.recycle();
        this.mTextSize = SupDialogStaticUtils.sp2px(this.getContext(), 14);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
    }

    @Override
    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int paintWidth = Math.max(this.mReachedProgressBarHeight, this.mUnReachedProgressBarHeight);
        if (heightMode != 0x40000000) {
            int exceptHeight = this.getPaddingTop() + this.getPaddingBottom() + this.mRadius * 2 + paintWidth;
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)exceptHeight, (int)0x40000000);
        }
        if (widthMode != 0x40000000) {
            int exceptWidth = this.getPaddingLeft() + this.getPaddingRight() + this.mRadius * 2 + paintWidth;
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)exceptWidth, (int)0x40000000);
        }
        super.onMeasure(heightMeasureSpec, heightMeasureSpec);
    }

    @Override
    protected synchronized void onDraw(Canvas canvas) {
        String text = this.getProgress() + "%";
        float textWidth = this.mPaint.measureText(text);
        float textHeight = (this.mPaint.descent() + this.mPaint.ascent()) / 2.0f;
        canvas.save();
        canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(this.mUnReachedBarColor);
        this.mPaint.setStrokeWidth((float)this.mUnReachedProgressBarHeight);
        canvas.drawCircle((float)(this.mRadius + this.mReachedProgressBarHeight / 2), (float)(this.mRadius + this.mReachedProgressBarHeight / 2), (float)this.mRadius, this.mPaint);
        this.mPaint.setColor(this.mReachedBarColor);
        this.mPaint.setStrokeWidth((float)this.mReachedProgressBarHeight);
        float sweepAngle = (float)this.getProgress() * 1.0f / (float)this.getMax() * 360.0f;
        canvas.drawArc(new RectF((float)(this.mReachedProgressBarHeight / 2), (float)(this.mReachedProgressBarHeight / 2), (float)(this.mRadius * 2 + this.mReachedProgressBarHeight / 2), (float)(this.mRadius * 2 + this.mReachedProgressBarHeight / 2)), 270.0f, sweepAngle, false, this.mPaint);
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawText(text, (float)this.mRadius - textWidth / 2.0f, (float)this.mRadius - textHeight, this.mPaint);
        canvas.restore();
    }
}

