/*
 * Decompiled with CFR 0.152.
 */
package com.fingerth.supdialogutils.progressbar.horizontal;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ProgressBar;
import com.fingerth.supdialogutils.R;
import com.fingerth.supdialogutils.utils.SupDialogStaticUtils;

public class HorizontalWithNumberProgressBar
extends ProgressBar {
    private static final int DEFAULT_TEXT_SIZE = 10;
    private static final int DEFAULT_TEXT_COLOR = -261935;
    private static final int DEFAULT_COLOR_UNREACHED_COLOR = -2894118;
    private static final int DEFAULT_HEIGHT_REACHED_PROGRESS_BAR = 2;
    private static final int DEFAULT_HEIGHT_UNREACHED_PROGRESS_BAR = 2;
    private static final int DEFAULT_SIZE_TEXT_OFFSET = 10;
    protected Paint mPaint = new Paint();
    protected int mTextColor = -261935;
    protected int mTextSize = SupDialogStaticUtils.sp2px(this.getContext(), 10);
    protected int mTextOffset = SupDialogStaticUtils.dp2px(this.getContext(), 10);
    protected int mReachedProgressBarHeight = SupDialogStaticUtils.dp2px(this.getContext(), 2);
    protected int mReachedBarColor = -261935;
    protected int mUnReachedBarColor = -2894118;
    protected int mUnReachedProgressBarHeight = SupDialogStaticUtils.dp2px(this.getContext(), 2);
    protected int mRealWidth;
    protected boolean mIfDrawText = true;
    protected static final int VISIBLE = 0;

    public HorizontalWithNumberProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HorizontalWithNumberProgressBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setHorizontalScrollBarEnabled(true);
        this.obtainStyledAttributes(attrs);
        this.mPaint.setTextSize((float)this.mTextSize);
        this.mPaint.setColor(this.mTextColor);
    }

    private void obtainStyledAttributes(AttributeSet attrs) {
        TypedArray attributes = this.getContext().obtainStyledAttributes(attrs, R.styleable.HorizontalWithNumberProgressBar);
        this.mTextColor = attributes.getColor(R.styleable.HorizontalWithNumberProgressBar_progressbar_text_color, -261935);
        this.mTextSize = (int)attributes.getDimension(R.styleable.HorizontalWithNumberProgressBar_progressbar_text_size, (float)this.mTextSize);
        this.mReachedBarColor = attributes.getColor(R.styleable.HorizontalWithNumberProgressBar_progressbar_reached_color, this.mTextColor);
        this.mUnReachedBarColor = attributes.getColor(R.styleable.HorizontalWithNumberProgressBar_progressbar_unreached_color, -2894118);
        this.mReachedProgressBarHeight = (int)attributes.getDimension(R.styleable.HorizontalWithNumberProgressBar_progressbar_reached_height, (float)this.mReachedProgressBarHeight);
        this.mUnReachedProgressBarHeight = (int)attributes.getDimension(R.styleable.HorizontalWithNumberProgressBar_progressbar_unreached_height, (float)this.mUnReachedProgressBarHeight);
        this.mTextOffset = (int)attributes.getDimension(R.styleable.HorizontalWithNumberProgressBar_progressbar_text_offset, (float)this.mTextOffset);
        int textVisible = attributes.getInt(R.styleable.HorizontalWithNumberProgressBar_progressbar_text_visibility, 0);
        if (textVisible != 0) {
            this.mIfDrawText = false;
        }
        attributes.recycle();
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (heightMode != 0x40000000) {
            float textHeight = this.mPaint.descent() + this.mPaint.ascent();
            int exceptHeight = (int)((float)(this.getPaddingTop() + this.getPaddingBottom()) + Math.max((float)Math.max(this.mReachedProgressBarHeight, this.mUnReachedProgressBarHeight), Math.abs(textHeight)));
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)exceptHeight, (int)0x40000000);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected synchronized void onDraw(Canvas canvas) {
        float endX;
        canvas.save();
        canvas.translate((float)this.getPaddingLeft(), (float)(this.getHeight() / 2));
        boolean noNeedBg = false;
        float radio = (float)this.getProgress() * 1.0f / (float)this.getMax();
        float progressPosX = (int)((float)this.mRealWidth * radio);
        String text = this.getProgress() + "%";
        float textWidth = this.mPaint.measureText(text);
        float textHeight = (this.mPaint.descent() + this.mPaint.ascent()) / 2.0f;
        if (progressPosX + textWidth > (float)this.mRealWidth) {
            progressPosX = (float)this.mRealWidth - textWidth;
            noNeedBg = true;
        }
        if ((endX = progressPosX - (float)(this.mTextOffset / 2)) > 0.0f) {
            this.mPaint.setColor(this.mReachedBarColor);
            this.mPaint.setStrokeWidth((float)this.mReachedProgressBarHeight);
            canvas.drawLine(0.0f, 0.0f, endX, 0.0f, this.mPaint);
        }
        if (this.mIfDrawText) {
            this.mPaint.setColor(this.mTextColor);
            canvas.drawText(text, progressPosX, -textHeight, this.mPaint);
        }
        if (!noNeedBg) {
            float start = progressPosX + (float)(this.mTextOffset / 2) + textWidth;
            this.mPaint.setColor(this.mUnReachedBarColor);
            this.mPaint.setStrokeWidth((float)this.mUnReachedProgressBarHeight);
            canvas.drawLine(start, 0.0f, (float)this.mRealWidth, 0.0f, this.mPaint);
        }
        canvas.restore();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mRealWidth = w - this.getPaddingRight() - this.getPaddingLeft();
    }
}

