/*
 * Decompiled with CFR 0.152.
 */
package com.fingerth.supdialogutils;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.fingerth.supdialogutils.R;
import com.fingerth.supdialogutils.progressbar.horizontal.HorizontalWithNumberProgressBar;
import com.fingerth.supdialogutils.utils.SupDialogStaticUtils;

public class SYSDiaLogUtils {
    private static String loadingStr = "\u6b63\u5728\u52a0\u8f09...";
    private static String successStr = "\u6210\u529f";
    private static String tipStr = "\u63d0\u793a";
    private static String errorStr = "\u932f\u8aa4";
    private static String confirmStr = "\u78ba\u8a8d";
    private static String cancelStr = "\u53d6\u6d88";
    private static ProgressDialog progressDialog;
    private static AlertDialog progressAlertDialog;
    private static HorizontalWithNumberProgressBar horizontalProgressBar;
    private static AlertDialog confirmDialog;
    private static ProgressDialog pDialog;
    private static AlertDialog pAlertDialog;
    private static AlertDialog tDialog;

    public static void setLangStr(String loadingStr, String successStr, String tipStr, String errorStr, String confirmStr, String cancelStr) {
        SYSDiaLogUtils.loadingStr = loadingStr;
        SYSDiaLogUtils.successStr = successStr;
        SYSDiaLogUtils.tipStr = tipStr;
        SYSDiaLogUtils.errorStr = errorStr;
        SYSDiaLogUtils.confirmStr = confirmStr;
        SYSDiaLogUtils.cancelStr = cancelStr;
    }

    private static void showDefaultProgressDialog(Activity context, SYSDiaLogType type, String title, String msg, boolean canceledOnTouchOutside, boolean cancelable, DialogInterface.OnCancelListener listener) {
        if (context == null || context.isFinishing()) {
            return;
        }
        SYSDiaLogUtils.closeKeyboardHidden(context);
        SYSDiaLogUtils.initDialog();
        if (TextUtils.isEmpty((CharSequence)title)) {
            title = "";
        }
        switch (type) {
            case IosType: {
                AlertDialog.Builder progressBuilder = new AlertDialog.Builder((Context)context, R.style.AlertDialog_Styles);
                View dialogView = View.inflate((Context)context, (int)R.layout.dialog_progress_view, null);
                LinearLayout dialog_progress_layout = (LinearLayout)dialogView.findViewById(R.id.dialog_progress_layout);
                FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)dialog_progress_layout.getLayoutParams();
                params.width = SupDialogStaticUtils.getScreenWidth(context) * 4 / 9;
                params.height = SupDialogStaticUtils.getScreenWidth(context) * 4 / 9;
                dialog_progress_layout.setLayoutParams((ViewGroup.LayoutParams)params);
                TextView message_tv = (TextView)dialogView.findViewById(R.id.message_tv);
                if (TextUtils.isEmpty((CharSequence)msg)) {
                    message_tv.setVisibility(8);
                } else {
                    message_tv.setText((CharSequence)msg);
                }
                progressBuilder.setView(dialogView);
                pAlertDialog = progressBuilder.create();
                pAlertDialog.setCanceledOnTouchOutside(canceledOnTouchOutside);
                pAlertDialog.setCancelable(cancelable);
                if (listener != null && cancelable) {
                    pAlertDialog.setOnCancelListener(listener);
                }
                pAlertDialog.show();
                break;
            }
            default: {
                if (TextUtils.isEmpty((CharSequence)msg)) {
                    msg = loadingStr;
                }
                pDialog = ProgressDialog.show((Context)context, (CharSequence)title, (CharSequence)msg);
                pDialog.setCanceledOnTouchOutside(canceledOnTouchOutside);
                pDialog.setCancelable(cancelable);
                if (listener == null || !cancelable) break;
                pDialog.setOnCancelListener(listener);
            }
        }
    }

    public static void dismissProgress() {
        SYSDiaLogUtils.initDialog();
    }

    public static void showSystemProgressDialog(Activity context, String title, String msg, boolean canceledOnTouchOutside, DialogInterface.OnCancelListener listener) {
        SYSDiaLogUtils.showDefaultProgressDialog(context, SYSDiaLogType.DefaultTpye, title, msg, canceledOnTouchOutside, true, listener);
    }

    public static void showSystemProgressDialog(Activity context, String title, String msg, boolean canceledOnTouchOutside, boolean cancelable) {
        SYSDiaLogUtils.showDefaultProgressDialog(context, SYSDiaLogType.DefaultTpye, title, msg, canceledOnTouchOutside, cancelable, null);
    }

    public static void showSystemProgressDialog(Activity context, String title, String msg) {
        SYSDiaLogUtils.showDefaultProgressDialog(context, SYSDiaLogType.DefaultTpye, title, msg, false, true, null);
    }

    public static void showSystemProgressDialog(Activity context, String msg) {
        SYSDiaLogUtils.showDefaultProgressDialog(context, SYSDiaLogType.DefaultTpye, "", msg, false, true, null);
    }

    public static void showSystemProgressDialog(Activity context) {
        SYSDiaLogUtils.showDefaultProgressDialog(context, SYSDiaLogType.DefaultTpye, "", "", false, true, null);
    }

    public static void showProgressDialog(Activity context, SYSDiaLogType type, String msg, boolean canceledOnTouchOutside, DialogInterface.OnCancelListener listener) {
        SYSDiaLogUtils.showDefaultProgressDialog(context, type, "", msg, canceledOnTouchOutside, true, listener);
    }

    public static void showProgressDialog(Activity context, SYSDiaLogType type, String msg, boolean canceledOnTouchOutside, boolean cancelable) {
        SYSDiaLogUtils.showDefaultProgressDialog(context, type, "", msg, canceledOnTouchOutside, cancelable, null);
    }

    public static void showProgressDialog(Activity context, SYSDiaLogType type, String msg) {
        SYSDiaLogUtils.showDefaultProgressDialog(context, type, "", msg, false, true, null);
    }

    public static void showProgressDialog(Activity context, SYSDiaLogType type) {
        SYSDiaLogUtils.showDefaultProgressDialog(context, type, "", "", false, true, null);
    }

    private static void closeKeyboardHidden(Activity context) {
        View view = context.getWindow().peekDecorView();
        if (view != null) {
            InputMethodManager inputmanger = (InputMethodManager)context.getSystemService("input_method");
            inputmanger.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    private static void initDialog() {
        if (pDialog != null && pDialog.isShowing()) {
            pDialog.dismiss();
            pDialog = null;
        }
        if (tDialog != null && tDialog.isShowing()) {
            tDialog.dismiss();
            tDialog = null;
        }
        if (pAlertDialog != null && pAlertDialog.isShowing()) {
            pAlertDialog.dismiss();
            pAlertDialog = null;
        }
        if (progressDialog != null && progressDialog.isShowing()) {
            progressDialog.dismiss();
            progressDialog = null;
        }
        if (progressAlertDialog != null && progressAlertDialog.isShowing()) {
            progressAlertDialog.dismiss();
            progressAlertDialog = null;
        }
        if (confirmDialog != null && confirmDialog.isShowing()) {
            confirmDialog.dismiss();
            confirmDialog = null;
        }
    }

    private static void showAlertDialog(Activity context, String title, String msg, String confirmStr, int type, boolean canceledOnTouchOutside) {
        if (context == null || context.isFinishing()) {
            return;
        }
        SYSDiaLogUtils.closeKeyboardHidden(context);
        SYSDiaLogUtils.initDialog();
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)context, R.style.AlertDialog_Styles);
        View dialogView = View.inflate((Context)context, (int)R.layout.dialog_alert_view, null);
        LinearLayout dialog_view_layout = (LinearLayout)dialogView.findViewById(R.id.dialog_view_layout);
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)dialog_view_layout.getLayoutParams();
        params.width = SupDialogStaticUtils.getScreenWidth(context) * 2 / 3;
        dialog_view_layout.setLayoutParams((ViewGroup.LayoutParams)params);
        ImageView dialog_icon = (ImageView)dialogView.findViewById(R.id.dialog_icon);
        TextView confirm = (TextView)dialogView.findViewById(R.id.confirm);
        if (TextUtils.isEmpty((CharSequence)confirmStr)) {
            confirmStr = SYSDiaLogUtils.confirmStr;
        }
        confirm.setText((CharSequence)confirmStr);
        confirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (tDialog != null && tDialog.isShowing()) {
                    tDialog.dismiss();
                }
            }
        });
        switch (type) {
            case 1: {
                if (TextUtils.isEmpty((CharSequence)title)) {
                    title = successStr;
                }
                dialog_icon.setImageDrawable(context.getResources().getDrawable(R.drawable.dialog_success));
                confirm.setBackground(context.getResources().getDrawable(R.drawable.selector_green));
                break;
            }
            case 2: {
                if (TextUtils.isEmpty((CharSequence)title)) {
                    title = tipStr;
                }
                dialog_icon.setImageDrawable(context.getResources().getDrawable(R.drawable.dialog_tip));
                confirm.setBackground(context.getResources().getDrawable(R.drawable.selector_tip_color));
                break;
            }
            case 3: {
                if (TextUtils.isEmpty((CharSequence)title)) {
                    title = errorStr;
                }
                dialog_icon.setImageDrawable(context.getResources().getDrawable(R.drawable.dialog_error));
                confirm.setBackground(context.getResources().getDrawable(R.drawable.selector_error_red));
                break;
            }
        }
        TextView title_tv = (TextView)dialogView.findViewById(R.id.title_tv);
        title_tv.setText((CharSequence)title);
        TextView message_tv = (TextView)dialogView.findViewById(R.id.message_tv);
        if (TextUtils.isEmpty((CharSequence)msg)) {
            message_tv.setVisibility(8);
        } else {
            message_tv.setText((CharSequence)msg);
        }
        builder.setView(dialogView);
        tDialog = builder.create();
        tDialog.setCanceledOnTouchOutside(canceledOnTouchOutside);
        tDialog.show();
    }

    public static void showSuccessDialog(Activity context, String title, String msg, String confirmStr, boolean canceledOnTouchOutside) {
        SYSDiaLogUtils.showAlertDialog(context, title, msg, confirmStr, 1, canceledOnTouchOutside);
    }

    public static void showSuccessDialog(Activity context, String title, String confirmStr, boolean canceledOnTouchOutside) {
        SYSDiaLogUtils.showAlertDialog(context, title, "", confirmStr, 1, canceledOnTouchOutside);
    }

    public static void showSuccessDialog(Activity context, String confirmStr, boolean canceledOnTouchOutside) {
        SYSDiaLogUtils.showAlertDialog(context, "", "", confirmStr, 1, canceledOnTouchOutside);
    }

    public static void showSuccessDialog(Activity context, boolean canceledOnTouchOutside) {
        SYSDiaLogUtils.showAlertDialog(context, "", "", "", 1, canceledOnTouchOutside);
    }

    public static void showInfoDialog(Activity context, String title, String msg, String confirmStr, boolean canceledOnTouchOutside) {
        SYSDiaLogUtils.showAlertDialog(context, title, msg, confirmStr, 2, canceledOnTouchOutside);
    }

    public static void showInfoDialog(Activity context, String title, String confirmStr, boolean canceledOnTouchOutside) {
        SYSDiaLogUtils.showAlertDialog(context, title, "", confirmStr, 2, canceledOnTouchOutside);
    }

    public static void showInfoDialog(Activity context, String confirmStr, boolean canceledOnTouchOutside) {
        SYSDiaLogUtils.showAlertDialog(context, "", "", confirmStr, 2, canceledOnTouchOutside);
    }

    public static void showInfoDialog(Activity context, boolean canceledOnTouchOutside) {
        SYSDiaLogUtils.showAlertDialog(context, "", "", "", 2, canceledOnTouchOutside);
    }

    public static void showErrorDialog(Activity context, String title, String msg, String confirmStr, boolean canceledOnTouchOutside) {
        SYSDiaLogUtils.showAlertDialog(context, title, msg, confirmStr, 3, canceledOnTouchOutside);
    }

    public static void showErrorDialog(Activity context, String title, String confirmStr, boolean canceledOnTouchOutside) {
        SYSDiaLogUtils.showAlertDialog(context, title, "", confirmStr, 3, canceledOnTouchOutside);
    }

    public static void showErrorDialog(Activity context, String confirmStr, boolean canceledOnTouchOutside) {
        SYSDiaLogUtils.showAlertDialog(context, "", "", confirmStr, 3, canceledOnTouchOutside);
    }

    public static void showErrorDialog(Activity context, boolean canceledOnTouchOutside) {
        SYSDiaLogUtils.showAlertDialog(context, "", "", "", 3, canceledOnTouchOutside);
    }

    private static void showDefaultProgressBar(Activity context, SYSDiaLogType type, String title, String msg, boolean canceledOnTouchOutside, boolean cancelable, DialogInterface.OnCancelListener listener) {
        if (context == null || context.isFinishing()) {
            return;
        }
        SYSDiaLogUtils.closeKeyboardHidden(context);
        SYSDiaLogUtils.initDialog();
        if (TextUtils.isEmpty((CharSequence)title)) {
            title = "";
        }
        switch (type) {
            case HorizontalWithNumberProgressBar: {
                AlertDialog.Builder progressBarBuilder = new AlertDialog.Builder((Context)context, R.style.AlertDialog_Styles);
                View dialogView = View.inflate((Context)context, (int)R.layout.dialog_horizontal_progressbar_view, null);
                LinearLayout dialog_progress_layout = (LinearLayout)dialogView.findViewById(R.id.dialog_progress_layout);
                FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)dialog_progress_layout.getLayoutParams();
                params.width = SupDialogStaticUtils.getScreenWidth(context) * 9 / 10;
                params.height = SupDialogStaticUtils.dp2px((Context)context, 120);
                dialog_progress_layout.setLayoutParams((ViewGroup.LayoutParams)params);
                TextView message_tv = (TextView)dialogView.findViewById(R.id.message_tv);
                TextView title_tv = (TextView)dialogView.findViewById(R.id.title_tv);
                horizontalProgressBar = (HorizontalWithNumberProgressBar)dialogView.findViewById(R.id.horizontal_bar);
                if (TextUtils.isEmpty((CharSequence)title)) {
                    title_tv.setVisibility(8);
                } else {
                    title_tv.setText((CharSequence)title);
                }
                if (TextUtils.isEmpty((CharSequence)msg)) {
                    message_tv.setVisibility(8);
                } else {
                    message_tv.setText((CharSequence)msg);
                }
                progressBarBuilder.setView(dialogView);
                progressAlertDialog = progressBarBuilder.create();
                progressAlertDialog.setCanceledOnTouchOutside(canceledOnTouchOutside);
                progressAlertDialog.setCancelable(cancelable);
                if (listener != null && cancelable) {
                    progressAlertDialog.setOnCancelListener(listener);
                }
                progressAlertDialog.show();
                break;
            }
            case RoundWidthNumberProgressBar: {
                AlertDialog.Builder roundProgressBarBuilder = new AlertDialog.Builder((Context)context, R.style.AlertDialog_Styles);
                View rounddialogView = View.inflate((Context)context, (int)R.layout.dialog_round_progressbar_view, null);
                LinearLayout dialog_round_progress_layout = (LinearLayout)rounddialogView.findViewById(R.id.dialog_progress_layout);
                FrameLayout.LayoutParams params1 = (FrameLayout.LayoutParams)dialog_round_progress_layout.getLayoutParams();
                params1.width = SupDialogStaticUtils.dp2px((Context)context, 140);
                params1.height = SupDialogStaticUtils.dp2px((Context)context, 140);
                dialog_round_progress_layout.setLayoutParams((ViewGroup.LayoutParams)params1);
                TextView messageTv = (TextView)rounddialogView.findViewById(R.id.message_tv);
                horizontalProgressBar = (HorizontalWithNumberProgressBar)rounddialogView.findViewById(R.id.round_bar);
                if (TextUtils.isEmpty((CharSequence)msg)) {
                    if (TextUtils.isEmpty((CharSequence)title)) {
                        messageTv.setVisibility(8);
                    } else {
                        messageTv.setText((CharSequence)title);
                    }
                } else {
                    messageTv.setText((CharSequence)msg);
                }
                roundProgressBarBuilder.setView(rounddialogView);
                progressAlertDialog = roundProgressBarBuilder.create();
                progressAlertDialog.setCanceledOnTouchOutside(canceledOnTouchOutside);
                progressAlertDialog.setCancelable(cancelable);
                if (listener != null && cancelable) {
                    progressAlertDialog.setOnCancelListener(listener);
                }
                progressAlertDialog.show();
                break;
            }
            default: {
                if (TextUtils.isEmpty((CharSequence)msg)) {
                    msg = loadingStr;
                }
                progressDialog = new ProgressDialog((Context)context);
                progressDialog.setProgressStyle(1);
                progressDialog.setTitle((CharSequence)title);
                progressDialog.setMessage((CharSequence)msg);
                progressDialog.setCanceledOnTouchOutside(canceledOnTouchOutside);
                progressDialog.setCancelable(cancelable);
                if (listener != null && cancelable) {
                    progressDialog.setOnCancelListener(listener);
                }
                progressDialog.show();
            }
        }
    }

    public static void showProgressBar(Activity context, String title, String msg, boolean canceledOnTouchOutside, DialogInterface.OnCancelListener listener) {
        SYSDiaLogUtils.showDefaultProgressBar(context, SYSDiaLogType.DefaultTpye, title, msg, canceledOnTouchOutside, true, listener);
    }

    public static void showProgressBar(Activity context, String title, String msg, boolean canceledOnTouchOutside, boolean cancelable) {
        SYSDiaLogUtils.showDefaultProgressBar(context, SYSDiaLogType.DefaultTpye, title, msg, canceledOnTouchOutside, cancelable, null);
    }

    public static void showProgressBar(Activity context, String title, String msg) {
        SYSDiaLogUtils.showDefaultProgressBar(context, SYSDiaLogType.DefaultTpye, title, msg, false, false, null);
    }

    public static void showProgressBar(Activity context, String msg) {
        SYSDiaLogUtils.showDefaultProgressBar(context, SYSDiaLogType.DefaultTpye, "", msg, false, false, null);
    }

    public static void showProgressBar(Activity context) {
        SYSDiaLogUtils.showDefaultProgressBar(context, SYSDiaLogType.DefaultTpye, "", "", false, false, null);
    }

    public static void setProgressBar(int progress) {
        if (progressDialog != null && progressDialog.isShowing()) {
            progressDialog.setProgress(progress);
        }
        if (progressAlertDialog != null && progressAlertDialog.isShowing() && horizontalProgressBar != null) {
            horizontalProgressBar.setProgress(progress);
        }
    }

    public static int getProgressBar() {
        if (progressDialog != null && progressDialog.isShowing()) {
            return progressDialog.getProgress();
        }
        if (progressAlertDialog != null && progressAlertDialog.isShowing() && horizontalProgressBar != null) {
            return horizontalProgressBar.getProgress();
        }
        return 0;
    }

    public static void showProgressBar(Activity context, SYSDiaLogType type, String title, String msg, boolean canceledOnTouchOutside, DialogInterface.OnCancelListener listener) {
        SYSDiaLogUtils.showDefaultProgressBar(context, type, title, msg, canceledOnTouchOutside, true, listener);
    }

    public static void showProgressBar(Activity context, SYSDiaLogType type, String title, String msg, boolean canceledOnTouchOutside, boolean cancelable) {
        SYSDiaLogUtils.showDefaultProgressBar(context, type, title, msg, canceledOnTouchOutside, cancelable, null);
    }

    public static void showProgressBar(Activity context, SYSDiaLogType type, String title, String msg) {
        SYSDiaLogUtils.showDefaultProgressBar(context, type, title, msg, false, false, null);
    }

    public static void showProgressBar(Activity context, SYSDiaLogType type, String msg) {
        SYSDiaLogUtils.showDefaultProgressBar(context, type, "", msg, false, false, null);
    }

    public static void showProgressBar(Activity context, SYSDiaLogType type) {
        SYSDiaLogUtils.showDefaultProgressBar(context, type, "", "", false, false, null);
    }

    private static void showConfirmAlertDialog(Activity context, boolean isShowPic, SYSConfirmType picType, String title, String msg, String confirmStr, String cancelStr, boolean canceledOnTouchOutside, boolean cancelable, final ConfirmDialogListener confirmDialogListener) {
        if (context == null || context.isFinishing()) {
            return;
        }
        SYSDiaLogUtils.closeKeyboardHidden(context);
        SYSDiaLogUtils.initDialog();
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)context, R.style.AlertDialog_Styles);
        View dialogView = View.inflate((Context)context, (int)R.layout.dialog_confirm_alert_view, null);
        LinearLayout dialog_view_layout = (LinearLayout)dialogView.findViewById(R.id.dialog_view_layout);
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)dialog_view_layout.getLayoutParams();
        params.width = SupDialogStaticUtils.getScreenWidth(context) * 2 / 3;
        dialog_view_layout.setLayoutParams((ViewGroup.LayoutParams)params);
        ImageView dialog_icon = (ImageView)dialogView.findViewById(R.id.dialog_icon);
        TextView confirm = (TextView)dialogView.findViewById(R.id.confirm);
        TextView cancel = (TextView)dialogView.findViewById(R.id.cancel);
        if (TextUtils.isEmpty((CharSequence)confirmStr)) {
            confirmStr = SYSDiaLogUtils.confirmStr;
        }
        if (TextUtils.isEmpty((CharSequence)cancelStr)) {
            cancelStr = SYSDiaLogUtils.cancelStr;
        }
        confirm.setText((CharSequence)confirmStr);
        cancel.setText((CharSequence)cancelStr);
        confirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (confirmDialogListener != null) {
                    confirmDialogListener.onClickButton(true, false);
                }
                if (confirmDialog != null && confirmDialog.isShowing()) {
                    confirmDialog.dismiss();
                }
            }
        });
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (confirmDialogListener != null) {
                    confirmDialogListener.onClickButton(false, true);
                }
                if (confirmDialog != null && confirmDialog.isShowing()) {
                    confirmDialog.dismiss();
                }
            }
        });
        if (!isShowPic) {
            dialog_icon.setVisibility(8);
        } else {
            switch (picType) {
                case Success: {
                    if (TextUtils.isEmpty((CharSequence)title) && TextUtils.isEmpty((CharSequence)msg)) {
                        title = successStr;
                    }
                    dialog_icon.setImageDrawable(context.getResources().getDrawable(R.drawable.dialog_success));
                    confirm.setBackground(context.getResources().getDrawable(R.drawable.selector_green));
                    break;
                }
                case Tip: {
                    if (TextUtils.isEmpty((CharSequence)title) && TextUtils.isEmpty((CharSequence)msg)) {
                        title = tipStr;
                    }
                    dialog_icon.setImageDrawable(context.getResources().getDrawable(R.drawable.dialog_tip));
                    confirm.setBackground(context.getResources().getDrawable(R.drawable.selector_tip_color));
                    break;
                }
                case Warning: {
                    if (TextUtils.isEmpty((CharSequence)title) && TextUtils.isEmpty((CharSequence)msg)) {
                        title = errorStr;
                    }
                    dialog_icon.setImageDrawable(context.getResources().getDrawable(R.drawable.dialog_error));
                    confirm.setBackground(context.getResources().getDrawable(R.drawable.selector_error_red));
                    break;
                }
                default: {
                    dialog_icon.setVisibility(8);
                }
            }
        }
        TextView title_tv = (TextView)dialogView.findViewById(R.id.title_tv);
        if (TextUtils.isEmpty((CharSequence)title)) {
            title_tv.setVisibility(8);
        } else {
            title_tv.setText((CharSequence)title);
        }
        TextView message_tv = (TextView)dialogView.findViewById(R.id.message_tv);
        if (TextUtils.isEmpty((CharSequence)msg)) {
            message_tv.setVisibility(8);
        } else {
            message_tv.setText((CharSequence)msg);
        }
        builder.setView(dialogView);
        confirmDialog = builder.create();
        confirmDialog.setCanceledOnTouchOutside(canceledOnTouchOutside);
        confirmDialog.setCancelable(cancelable);
        confirmDialog.show();
    }

    public static void showConfirmDialog(Activity context, boolean isShowPic, SYSConfirmType picType, String title, String msg, String confirmStr, String cancelStr, boolean canceledOnTouchOutside, boolean cancelable, ConfirmDialogListener confirmDialogListener) {
        SYSDiaLogUtils.showConfirmAlertDialog(context, isShowPic, picType, title, msg, confirmStr, cancelStr, canceledOnTouchOutside, cancelable, confirmDialogListener);
    }

    public static void showConfirmDialog(Activity context, boolean isShowPic, SYSConfirmType picType, String title, String msg, ConfirmDialogListener confirmDialogListener) {
        SYSDiaLogUtils.showConfirmAlertDialog(context, isShowPic, picType, title, msg, "", "", false, true, confirmDialogListener);
    }

    public static void showConfirmDialog(Activity context, String title, String msg, String confirmStr, String cancelStr, boolean canceledOnTouchOutside, boolean cancelable, ConfirmDialogListener confirmDialogListener) {
        SYSDiaLogUtils.showConfirmAlertDialog(context, false, SYSConfirmType.Success, title, msg, confirmStr, cancelStr, canceledOnTouchOutside, cancelable, confirmDialogListener);
    }

    public static void showConfirmDialog(Activity context, String title, String msg, String confirmStr, String cancelStr, ConfirmDialogListener confirmDialogListener) {
        SYSDiaLogUtils.showConfirmAlertDialog(context, false, SYSConfirmType.Success, title, msg, confirmStr, cancelStr, false, true, confirmDialogListener);
    }

    public static void showConfirmDialog(Activity context, String title, String msg, ConfirmDialogListener confirmDialogListener) {
        SYSDiaLogUtils.showConfirmAlertDialog(context, false, SYSConfirmType.Success, title, msg, "", "", false, true, confirmDialogListener);
    }

    public static void showConfirmDialog(Activity context, String msg, ConfirmDialogListener confirmDialogListener) {
        SYSDiaLogUtils.showConfirmAlertDialog(context, false, SYSConfirmType.Success, "", msg, "", "", false, true, confirmDialogListener);
    }

    public static interface ConfirmDialogListener {
        public void onClickButton(boolean var1, boolean var2);
    }

    public static enum SYSConfirmType {
        Success,
        Tip,
        Warning;

    }

    public static enum SYSDiaLogType {
        DefaultTpye,
        IosType,
        HorizontalWithNumberProgressBar,
        RoundWidthNumberProgressBar,
        Black;

    }
}

