/*
 * Decompiled with CFR 0.152.
 */
package com.github.fgiannesini.libsass.gradle.plugin.extension;

import com.github.fgiannesini.libsass.gradle.plugin.compiler.PluginInputSyntax;
import com.github.fgiannesini.libsass.gradle.plugin.compiler.PluginOutputStyle;
import com.github.fgiannesini.libsass.gradle.plugin.extension.PluginMode;
import com.github.fgiannesini.libsass.gradle.plugin.extension.PluginParameters;
import com.github.fgiannesini.libsass.gradle.plugin.extension.PluginProductionParameters;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

public class PluginParametersProvider {
    private final PluginParameters parameters;
    private PluginProductionParameters productionParameters;
    private final Project project;

    public PluginParametersProvider(Project project, PluginMode pluginMode) {
        this.parameters = (PluginParameters)project.getExtensions().getByType(PluginParameters.class);
        if (this.parameters != null && PluginMode.PRODUCTION.equals((Object)pluginMode)) {
            this.productionParameters = (PluginProductionParameters)((ExtensionAware)ExtensionAware.class.cast(this.parameters)).getExtensions().findByType(PluginProductionParameters.class);
        }
        this.project = project;
    }

    public URI getInputUri() {
        File file;
        String value = null;
        String productionParameter = null;
        if (this.productionParameters != null) {
            productionParameter = this.productionParameters.getInputFilePath();
        }
        String devParameter = null;
        if (this.parameters != null) {
            devParameter = this.parameters.getInputFilePath();
        }
        if (productionParameter != null) {
            value = productionParameter;
        } else if (devParameter != null) {
            value = devParameter;
        }
        if (value == null) {
            value = "scss" + File.separator + this.project.getName().toLowerCase() + ".scss";
        }
        if (!(file = this.getResourcePath(value).toFile()).exists()) {
            throw new IllegalArgumentException("Input file " + file.getAbsolutePath() + " does not exist ");
        }
        return file.toURI();
    }

    private Path getResourcePath(String value) {
        Path resourcePath = ((File)((SourceSet)((JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main")).getAllSource().getSrcDirs().iterator().next()).toPath().resolve(value);
        if (!resourcePath.toFile().exists()) {
            resourcePath = this.project.getRootDir().toPath().resolve(value);
        }
        return resourcePath;
    }

    public URI getOutputUri() {
        String value = null;
        String productionParameter = null;
        if (this.productionParameters != null) {
            productionParameter = this.productionParameters.getOutputFilePath();
        }
        String devParameter = null;
        if (this.parameters != null) {
            devParameter = this.parameters.getOutputFilePath();
        }
        if (productionParameter != null) {
            value = productionParameter;
        } else if (devParameter != null) {
            value = devParameter;
        }
        if (value == null) {
            value = "css" + File.separator + this.project.getName().toLowerCase() + ".css";
        }
        return this.getResourcePath(value).toUri();
    }

    public Boolean getSourceMapContents() {
        Boolean value = Boolean.FALSE;
        Boolean productionParameter = null;
        if (this.productionParameters != null && this.productionParameters.getSourceMapContents() != null) {
            productionParameter = this.productionParameters.getSourceMapContents();
        }
        Boolean devParameter = null;
        if (this.parameters != null) {
            devParameter = this.parameters.getSourceMapContents();
        }
        if (productionParameter != null) {
            value = productionParameter;
        } else if (devParameter != null) {
            value = devParameter;
        }
        return value;
    }

    public Boolean getSourceMapEmbed() {
        Boolean value = Boolean.FALSE;
        Boolean productionParameter = null;
        if (this.productionParameters != null && this.productionParameters.getSourceMapEmbed() != null) {
            productionParameter = this.productionParameters.getSourceMapEmbed();
        }
        Boolean devParameter = null;
        if (this.parameters != null) {
            devParameter = this.parameters.getSourceMapEmbed();
        }
        if (productionParameter != null) {
            value = productionParameter;
        } else if (devParameter != null) {
            value = devParameter;
        }
        return value;
    }

    public Boolean getSourceComments() {
        Boolean value = Boolean.FALSE;
        Boolean productionParameter = null;
        if (this.productionParameters != null && this.productionParameters.getSourceComments() != null) {
            productionParameter = this.productionParameters.getSourceComments();
        }
        Boolean devParameter = null;
        if (this.parameters != null) {
            devParameter = this.parameters.getSourceComments();
        }
        if (productionParameter != null) {
            value = productionParameter;
        } else if (devParameter != null) {
            value = devParameter;
        }
        return value;
    }

    public boolean getOmitSourceMappingUrl() {
        Boolean value = Boolean.FALSE;
        Boolean productionParameter = null;
        if (this.productionParameters != null && this.productionParameters.getOmitSourceMappingURL() != null) {
            productionParameter = this.productionParameters.getOmitSourceMappingURL();
        }
        Boolean devParameter = null;
        if (this.parameters != null) {
            devParameter = this.parameters.getOmitSourceMappingURL();
        }
        if (productionParameter != null) {
            value = productionParameter;
        } else if (devParameter != null) {
            value = devParameter;
        }
        return value;
    }

    public PluginInputSyntax getInputSyntax() {
        PluginInputSyntax value = PluginInputSyntax.SCSS;
        PluginInputSyntax productionParameter = null;
        if (this.productionParameters != null && this.productionParameters.getInputSyntax() != null) {
            productionParameter = PluginInputSyntax.valueOf(this.productionParameters.getInputSyntax().toUpperCase());
        }
        PluginInputSyntax devParameter = null;
        if (this.parameters != null && this.parameters.getInputSyntax() != null) {
            devParameter = PluginInputSyntax.valueOf(this.parameters.getInputSyntax().toUpperCase());
        }
        if (productionParameter != null) {
            value = productionParameter;
        } else if (devParameter != null) {
            value = devParameter;
        }
        return value;
    }

    public PluginOutputStyle getOutputStyle() {
        PluginOutputStyle value = PluginOutputStyle.NESTED;
        PluginOutputStyle productionParameter = null;
        if (this.productionParameters != null && this.productionParameters.getOutputStyle() != null) {
            productionParameter = PluginOutputStyle.valueOf(this.productionParameters.getOutputStyle().toUpperCase());
        }
        PluginOutputStyle devParameter = null;
        if (this.parameters != null && this.parameters.getOutputStyle() != null) {
            devParameter = PluginOutputStyle.valueOf(this.parameters.getOutputStyle().toUpperCase());
        }
        if (productionParameter != null) {
            value = productionParameter;
        } else if (devParameter != null) {
            value = devParameter;
        }
        return value;
    }

    public int getPrecision() {
        Integer value = 5;
        Integer productionParameter = null;
        if (this.productionParameters != null && this.productionParameters.getInputSyntax() != null) {
            productionParameter = Integer.valueOf(this.productionParameters.getInputSyntax());
        }
        Integer devParameter = null;
        if (this.parameters != null && this.parameters.getInputSyntax() != null) {
            devParameter = Integer.valueOf(this.parameters.getInputSyntax());
        }
        if (productionParameter != null) {
            value = productionParameter;
        } else if (devParameter != null) {
            value = devParameter;
        }
        return value;
    }

    public String[] getIncludePaths() {
        String value = "";
        String productionParameter = null;
        if (this.productionParameters != null && this.productionParameters.getIncludePaths() != null) {
            productionParameter = this.productionParameters.getIncludePaths();
        }
        String devParameter = null;
        if (this.parameters != null) {
            devParameter = this.parameters.getIncludePaths();
        }
        if (productionParameter != null) {
            value = productionParameter;
        } else if (devParameter != null) {
            value = devParameter;
        }
        return value.split(File.pathSeparator);
    }

    public URI getSourceMapUri() {
        String value = null;
        String productionParameter = null;
        if (this.productionParameters != null) {
            productionParameter = this.productionParameters.getSourceMapFilePath();
        }
        String devParameter = null;
        if (this.parameters != null) {
            devParameter = this.parameters.getSourceMapFilePath();
        }
        if (productionParameter != null) {
            value = productionParameter;
        } else if (devParameter != null) {
            value = devParameter;
        }
        if (value == null) {
            return null;
        }
        return this.getResourcePath(value).toUri();
    }

    public Path getCompassInstallationPath() {
        String value = "scss";
        if (this.parameters != null && this.parameters.getCompassInstallationPath() != null) {
            value = this.parameters.getCompassInstallationPath();
        }
        return this.getResourcePath(value);
    }

    public String getCompassVersion() {
        String value = "";
        if (this.parameters != null && this.parameters.getCompassVersion() != null) {
            value = this.parameters.getCompassVersion();
        }
        return value;
    }

    public Path getBourbonInstallationPath() {
        String value = "scss";
        if (this.parameters != null && this.parameters.getBourbonInstallationPath() != null) {
            value = this.parameters.getBourbonInstallationPath();
        }
        return this.getResourcePath(value);
    }

    public String getBourbonVersion() {
        String value = "";
        if (this.parameters != null && this.parameters.getBourbonVersion() != null) {
            value = this.parameters.getBourbonVersion();
        }
        return value;
    }

    public Path getLibsassWatchDirectory() {
        return this.getResourcePath(this.parameters.getWatchedDirectoryPath());
    }
}

