/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate;

import com.google.common.base.CharMatcher;

public final class CharMatchers {
    public static final CharMatcher LITERALS;
    public static final CharMatcher PERCENT;
    public static final CharMatcher HEXDIGIT;
    public static final CharMatcher UNRESERVED;
    public static final CharMatcher RESERVED_PLUS_UNRESERVED;

    private CharMatchers() {
    }

    static {
        PERCENT = CharMatcher.is((char)'%');
        HEXDIGIT = CharMatcher.inRange((char)'0', (char)'9').or(CharMatcher.inRange((char)'a', (char)'f')).or(CharMatcher.inRange((char)'A', (char)'F')).precomputed();
        CharMatcher reserved = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"-._~"));
        CharMatcher genDelims = CharMatcher.anyOf((CharSequence)":/?#[]@");
        CharMatcher subDelims = CharMatcher.anyOf((CharSequence)"!$&'()*+,;=");
        UNRESERVED = reserved.precomputed();
        RESERVED_PLUS_UNRESERVED = reserved.or(genDelims).or(subDelims).precomputed();
        CharMatcher ctl = CharMatcher.JAVA_ISO_CONTROL;
        CharMatcher spc = CharMatcher.WHITESPACE;
        CharMatcher other = CharMatcher.anyOf((CharSequence)"\"'<>\\^`{|}");
        LITERALS = ctl.or(spc).or(other).negate().precomputed();
    }
}

