/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.vars.specs;

import com.github.fge.uritemplate.URITemplateException;
import com.github.fge.uritemplate.expression.ExpressionType;
import com.github.fge.uritemplate.vars.specs.VariableSpec;
import com.github.fge.uritemplate.vars.specs.VariableSpecType;
import java.util.List;
import java.util.Map;

public final class PrefixVariable
extends VariableSpec {
    private final int length;

    public PrefixVariable(String name, int length) {
        super(VariableSpecType.PREFIX, name);
        this.length = length;
    }

    @Override
    protected String renderScalar(ExpressionType type, String value) throws URITemplateException {
        int len = Math.min(value.length(), this.length);
        String s = value.substring(0, len);
        String expanded = PrefixVariable.expandString(type, s);
        if (!PARAM_STYLE_EXPRESSIONS.contains((Object)type)) {
            return expanded;
        }
        StringBuilder sb = new StringBuilder(this.name);
        if (!expanded.isEmpty() || type != ExpressionType.PATH_PARAMETERS) {
            sb.append('=').append(expanded);
        }
        return sb.toString();
    }

    @Override
    protected String renderList(ExpressionType type, List<String> value) throws URITemplateException {
        throw new URITemplateException("incompatible varspec/value combination");
    }

    @Override
    protected String renderMap(ExpressionType type, Map<String, String> map) throws URITemplateException {
        throw new URITemplateException("incompatible varspec/value combination");
    }

    @Override
    public int hashCode() {
        return 31 * this.name.hashCode() + this.length;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrefixVariable other = (PrefixVariable)obj;
        return this.name.equals(other.name) && this.length == other.length;
    }

    @Override
    public String toString() {
        return this.name + " (prefix length: " + this.length + ')';
    }
}

