/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.parse;

import com.github.fge.uritemplate.URITemplateParseException;
import com.github.fge.uritemplate.parse.Matchers;
import com.github.fge.uritemplate.vars.ExplodedVariable;
import com.github.fge.uritemplate.vars.PrefixVariable;
import com.github.fge.uritemplate.vars.SimpleVariable;
import com.github.fge.uritemplate.vars.VariableSpec;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.nio.CharBuffer;
import java.util.ArrayList;

public final class VariableSpecParser {
    private static final Joiner JOINER = Joiner.on((char)'.');
    private static final CharMatcher VARCHAR = CharMatcher.inRange((char)'0', (char)'9').or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.is((char)'_')).or(Matchers.PERCENT).precomputed();
    private static final CharMatcher DOT = CharMatcher.is((char)'.');
    private static final CharMatcher COLON = CharMatcher.is((char)':');
    private static final CharMatcher STAR = CharMatcher.is((char)'*');
    private static final CharMatcher DIGIT = CharMatcher.inRange((char)'0', (char)'9').precomputed();

    private VariableSpecParser() {
    }

    public static VariableSpec parse(CharBuffer buffer) throws URITemplateParseException {
        String name = VariableSpecParser.parseFullName(buffer);
        if (!buffer.hasRemaining()) {
            return new SimpleVariable(name);
        }
        char c = buffer.charAt(0);
        if (STAR.matches(c)) {
            buffer.get();
            return new ExplodedVariable(name);
        }
        if (COLON.matches(c)) {
            buffer.get();
            return new PrefixVariable(name, VariableSpecParser.getPrefixLength(buffer));
        }
        return new SimpleVariable(name);
    }

    private static String parseFullName(CharBuffer buffer) throws URITemplateParseException {
        ArrayList components = Lists.newArrayList();
        while (true) {
            components.add(VariableSpecParser.readName(buffer));
            if (!buffer.hasRemaining() || !DOT.matches(buffer.charAt(0))) break;
            buffer.get();
        }
        return JOINER.join((Iterable)components);
    }

    private static String readName(CharBuffer buffer) throws URITemplateParseException {
        char c;
        StringBuilder sb = new StringBuilder();
        while (buffer.hasRemaining() && VARCHAR.matches(c = buffer.charAt(0))) {
            sb.append(buffer.get());
            if (!Matchers.PERCENT.matches(c)) continue;
            VariableSpecParser.parsePercentEncoded(buffer, sb);
        }
        String ret = sb.toString();
        if (ret.isEmpty()) {
            throw new URITemplateParseException("empty variable name", buffer);
        }
        return ret;
    }

    private static void parsePercentEncoded(CharBuffer buffer, StringBuilder sb) throws URITemplateParseException {
        if (buffer.remaining() < 2) {
            throw new URITemplateParseException("not enough remaining characters for a percent-encoded sequence", buffer, true);
        }
        char first = buffer.get();
        if (!Matchers.HEXDIGIT.matches(first)) {
            throw new URITemplateParseException("illegal character in percent-encoded sequence", buffer, true);
        }
        char second = buffer.get();
        if (!Matchers.HEXDIGIT.matches(second)) {
            throw new URITemplateParseException("illegal character in percent-encoded sequence", buffer, true);
        }
        sb.append(first).append(second);
    }

    private static int getPrefixLength(CharBuffer buffer) throws URITemplateParseException {
        char c;
        StringBuilder sb = new StringBuilder();
        while (buffer.hasRemaining() && DIGIT.matches(c = buffer.charAt(0))) {
            sb.append(buffer.get());
        }
        String s = sb.toString();
        if (s.isEmpty()) {
            throw new URITemplateParseException("prefix is empty", buffer, true);
        }
        try {
            int ret = Integer.parseInt(s);
            if (ret > 10000) {
                throw new NumberFormatException();
            }
            return ret;
        }
        catch (NumberFormatException ignored) {
            throw new URITemplateParseException("prefix length is too large (maximum 10000)", buffer, true);
        }
    }
}

