/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.msgsimple.source;

import com.github.fge.msgsimple.InternalBundle;
import com.github.fge.msgsimple.source.MessageSource;
import java.util.HashMap;
import java.util.Map;

public final class MapMessageSource
implements MessageSource {
    private static final InternalBundle BUNDLE = InternalBundle.getInstance();
    private final Map<String, String> messages;

    @Deprecated
    public MapMessageSource(Map<String, String> messages) {
        this.messages = new HashMap<String, String>(MapMessageSource.checkMap(messages));
    }

    private MapMessageSource(Builder builder) {
        this.messages = new HashMap<String, String>(builder.messages);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String getKey(String key) {
        return this.messages.get(key);
    }

    private static Map<String, String> checkMap(Map<String, String> map) {
        BUNDLE.checkNotNull(map, "cfg.nullMap");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            BUNDLE.checkNotNull(entry.getKey(), "cfg.map.nullKey");
            BUNDLE.checkNotNull(entry.getValue(), "cfg.map.nullValue");
        }
        return map;
    }

    public static final class Builder {
        private final Map<String, String> messages = new HashMap<String, String>();

        private Builder() {
        }

        public Builder put(String key, String message) {
            this.messages.put(BUNDLE.checkNotNull(key, "cfg.map.nullKey"), BUNDLE.checkNotNull(message, "cfg.map.nullValue"));
            return this;
        }

        public Builder putAll(Map<String, String> map) {
            for (Map.Entry<String, String> entry : BUNDLE.checkNotNull(map, "cfg.nullMap").entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public MessageSource build() {
            return new MapMessageSource(this);
        }
    }
}

