/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.msgsimple.provider;

import com.github.fge.msgsimple.provider.MessageSourceProvider;
import com.github.fge.msgsimple.source.MessageSource;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@Immutable
public final class StaticMessageSourceProvider
implements MessageSourceProvider {
    private final MessageSource defaultSource;
    private final Map<Locale, MessageSource> sources;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static MessageSourceProvider withSingleSource(MessageSource source) {
        return new Builder().setDefaultSource(source).build();
    }

    public static MessageSourceProvider withSingleSource(Locale locale, MessageSource source) {
        return new Builder().addSource(locale, source).build();
    }

    private StaticMessageSourceProvider(Builder builder) {
        this.defaultSource = builder.defaultSource;
        this.sources = new HashMap<Locale, MessageSource>(builder.sources);
    }

    @Override
    public MessageSource getMessageSource(Locale locale) {
        return this.sources.containsKey(locale) ? this.sources.get(locale) : this.defaultSource;
    }

    @NotThreadSafe
    public static final class Builder {
        private MessageSource defaultSource;
        private final Map<Locale, MessageSource> sources = new HashMap<Locale, MessageSource>();

        private Builder() {
        }

        public Builder addSource(Locale locale, MessageSource source) {
            if (locale == null) {
                throw new NullPointerException("null keys are not allowed");
            }
            if (source == null) {
                throw new NullPointerException("null sources are not allowed");
            }
            this.sources.put(locale, source);
            return this;
        }

        public Builder setDefaultSource(MessageSource source) {
            if (source == null) {
                throw new NullPointerException("cannot set null default source");
            }
            this.defaultSource = source;
            return this;
        }

        public MessageSourceProvider build() {
            return new StaticMessageSourceProvider(this);
        }
    }
}

