/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.msgsimple.source;

import com.github.fge.msgsimple.source.MessageSource;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class PropertiesMessageSource
implements MessageSource {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final Map<String, String> messages = new HashMap<String, String>();

    public static MessageSource fromResource(String resourcePath) throws IOException {
        if (resourcePath == null) {
            throw new NullPointerException("resource path is null");
        }
        InputStream in = PropertiesMessageSource.class.getResourceAsStream(resourcePath);
        if (in == null) {
            throw new IOException("resource \"" + resourcePath + "\" not found");
        }
        return PropertiesMessageSource.fromInputStream(in);
    }

    public static MessageSource fromFile(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is null");
        }
        return PropertiesMessageSource.fromInputStream(new FileInputStream(file));
    }

    public static MessageSource fromPath(String path) throws IOException {
        if (path == null) {
            throw new NullPointerException("file path is null");
        }
        return PropertiesMessageSource.fromFile(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageSource fromInputStream(InputStream in) throws IOException {
        if (in == null) {
            throw new NullPointerException("input stream is null");
        }
        InputStreamReader reader = new InputStreamReader(in, UTF8);
        try {
            Properties properties = new Properties();
            properties.load(reader);
            PropertiesMessageSource propertiesMessageSource = new PropertiesMessageSource(properties);
            return propertiesMessageSource;
        }
        finally {
            PropertiesMessageSource.closeQuietly(reader);
            PropertiesMessageSource.closeQuietly(in);
        }
    }

    private PropertiesMessageSource(Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            this.messages.put(key, properties.getProperty(key));
        }
    }

    @Override
    public String getMessage(String key) {
        return this.messages.get(key);
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

