/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.library;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.Thawed;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.keyword.digest.Digester;
import com.github.fge.jsonschema.keyword.digest.helpers.IdentityDigester;
import com.github.fge.jsonschema.keyword.digest.helpers.SimpleDigester;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.library.Keyword;
import com.github.fge.jsonschema.messages.JsonSchemaConfigurationBundle;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import java.lang.reflect.Constructor;

public final class KeywordBuilder
implements Thawed<Keyword> {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaConfigurationBundle.class);
    final String name;
    SyntaxChecker syntaxChecker;
    Digester digester;
    Constructor<? extends KeywordValidator> constructor;

    KeywordBuilder(String name) {
        BUNDLE.checkNotNull((Object)name, "nullName");
        this.name = name;
    }

    KeywordBuilder(Keyword keyword) {
        this.name = keyword.name;
        this.syntaxChecker = keyword.syntaxChecker;
        this.digester = keyword.digester;
        this.constructor = keyword.constructor;
    }

    public KeywordBuilder withSyntaxChecker(SyntaxChecker syntaxChecker) {
        BUNDLE.checkNotNullPrintf((Object)syntaxChecker, "nullSyntaxChecker", new Object[]{this.name});
        this.syntaxChecker = syntaxChecker;
        return this;
    }

    public KeywordBuilder withDigester(Digester digester) {
        BUNDLE.checkNotNullPrintf((Object)digester, "nullDigester", new Object[]{this.name});
        this.digester = digester;
        return this;
    }

    public KeywordBuilder withIdentityDigester(NodeType first, NodeType ... other) {
        this.digester = new IdentityDigester(this.name, KeywordBuilder.checkType(first), KeywordBuilder.checkTypes(other));
        return this;
    }

    public KeywordBuilder withSimpleDigester(NodeType first, NodeType ... other) {
        this.digester = new SimpleDigester(this.name, KeywordBuilder.checkType(first), KeywordBuilder.checkTypes(other));
        return this;
    }

    public KeywordBuilder withValidatorClass(Class<? extends KeywordValidator> c) {
        this.constructor = KeywordBuilder.getConstructor(this.name, c);
        return this;
    }

    public Keyword freeze() {
        BUNDLE.checkArgumentPrintf(this.syntaxChecker != null, "noChecker", new Object[]{this.name});
        BUNDLE.checkArgumentPrintf(this.constructor == null || this.digester != null, "malformedKeyword", new Object[]{this.name});
        return new Keyword(this);
    }

    private static Constructor<? extends KeywordValidator> getConstructor(String name, Class<? extends KeywordValidator> c) {
        try {
            return c.getConstructor(JsonNode.class);
        }
        catch (NoSuchMethodException ignored) {
            throw new IllegalArgumentException(BUNDLE.printf("noAppropriateConstructor", new Object[]{name, c.getCanonicalName()}));
        }
    }

    private static NodeType checkType(NodeType type) {
        return (NodeType)BUNDLE.checkNotNull((Object)type, "nullType");
    }

    private static NodeType[] checkTypes(NodeType ... types) {
        for (NodeType type : types) {
            BUNDLE.checkNotNull((Object)type, "nullType");
        }
        return types;
    }
}

