/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.library;

import com.github.fge.Thawed;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.keyword.digest.Digester;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.library.DictionaryBuilder;
import com.github.fge.jsonschema.library.Keyword;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.messages.JsonSchemaConfigurationBundle;
import com.github.fge.jsonschema.syntax.checkers.SyntaxChecker;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.serviceloader.MessageBundleFactory;
import java.lang.reflect.Constructor;

public final class LibraryBuilder
implements Thawed<Library> {
    private static final MessageBundle BUNDLE = MessageBundleFactory.getBundle(JsonSchemaConfigurationBundle.class);
    final DictionaryBuilder<SyntaxChecker> syntaxCheckers;
    final DictionaryBuilder<Digester> digesters;
    final DictionaryBuilder<Constructor<? extends KeywordValidator>> validators;
    final DictionaryBuilder<FormatAttribute> formatAttributes;

    LibraryBuilder() {
        this.syntaxCheckers = Dictionary.newBuilder();
        this.digesters = Dictionary.newBuilder();
        this.validators = Dictionary.newBuilder();
        this.formatAttributes = Dictionary.newBuilder();
    }

    LibraryBuilder(Library library) {
        this.syntaxCheckers = library.syntaxCheckers.thaw();
        this.digesters = library.digesters.thaw();
        this.validators = library.validators.thaw();
        this.formatAttributes = library.formatAttributes.thaw();
    }

    public LibraryBuilder addKeyword(Keyword keyword) {
        BUNDLE.checkNotNull((Object)keyword, "nullKeyword");
        String name = keyword.name;
        this.removeKeyword(name);
        this.syntaxCheckers.addEntry(name, keyword.syntaxChecker);
        if (keyword.constructor != null) {
            this.digesters.addEntry(name, keyword.digester);
            this.validators.addEntry(name, keyword.constructor);
        }
        return this;
    }

    public LibraryBuilder removeKeyword(String name) {
        BUNDLE.checkNotNull((Object)name, "nullName");
        this.syntaxCheckers.removeEntry(name);
        this.digesters.removeEntry(name);
        this.validators.removeEntry(name);
        return this;
    }

    public LibraryBuilder addFormatAttribute(String name, FormatAttribute attribute) {
        this.removeFormatAttribute(name);
        BUNDLE.checkNotNullPrintf((Object)attribute, "nullAttribute", new Object[]{name});
        this.formatAttributes.addEntry(name, attribute);
        return this;
    }

    public LibraryBuilder removeFormatAttribute(String name) {
        BUNDLE.checkNotNull((Object)name, "nullFormat");
        this.formatAttributes.removeEntry(name);
        return this;
    }

    public Library freeze() {
        return new Library(this);
    }
}

