/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.validation;

import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.load.RefResolver;
import com.github.fge.jsonschema.processing.CachingProcessor;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ProcessorChain;
import com.github.fge.jsonschema.processors.build.ValidatorBuilder;
import com.github.fge.jsonschema.processors.data.SchemaContext;
import com.github.fge.jsonschema.processors.data.ValidatorList;
import com.github.fge.jsonschema.processors.digest.SchemaDigester;
import com.github.fge.jsonschema.processors.format.FormatProcessor;
import com.github.fge.jsonschema.processors.validation.SchemaContextEquivalence;
import com.github.fge.jsonschema.report.ListProcessingReport;
import com.github.fge.jsonschema.report.MessageProvider;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.syntax.SyntaxProcessor;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.AsJson;
import com.github.fge.jsonschema.util.ValueHolder;
import com.github.fge.jsonschema.util.equivalence.SchemaTreeEquivalence;
import com.google.common.base.Equivalence;

public final class ValidationChain
implements Processor<SchemaContext, ValidatorList> {
    private final Processor<ValueHolder<SchemaTree>, ValueHolder<SchemaTree>> resolver;
    private final Processor<SchemaContext, ValidatorList> builder;

    public ValidationChain(RefResolver refResolver, Library library, boolean useFormat) {
        SyntaxProcessor syntaxProcessor = new SyntaxProcessor(library.getSyntaxCheckers());
        ProcessorChain chain1 = ProcessorChain.startWith((Processor)refResolver).chainWith((Processor)syntaxProcessor);
        this.resolver = new CachingProcessor(chain1.getProcessor(), SchemaHolderEquivalence.INSTANCE);
        SchemaDigester digester = new SchemaDigester(library);
        ValidatorBuilder keywordBuilder = new ValidatorBuilder(library);
        ProcessorChain chain2 = ProcessorChain.startWith((Processor)digester).chainWith((Processor)keywordBuilder);
        if (useFormat) {
            FormatProcessor format = new FormatProcessor(library);
            chain2 = chain2.chainWith((Processor)format);
        }
        this.builder = new CachingProcessor(chain2.getProcessor(), SchemaContextEquivalence.getInstance());
    }

    public ValidatorList process(ProcessingReport report, SchemaContext input) throws ProcessingException {
        ValueHolder in = ValueHolder.hold((String)"schema", (AsJson)input.getSchema());
        ListProcessingReport r = new ListProcessingReport(report);
        ValueHolder out = (ValueHolder)this.resolver.process((ProcessingReport)r, (MessageProvider)in);
        report.mergeWith((ProcessingReport)r);
        if (!r.isSuccess()) {
            return null;
        }
        SchemaContext output = new SchemaContext((SchemaTree)out.getValue(), input.getInstanceType());
        return (ValidatorList)this.builder.process(report, (MessageProvider)output);
    }

    public String toString() {
        return this.resolver + " -> " + this.builder;
    }

    private static final class SchemaHolderEquivalence
    extends Equivalence<ValueHolder<SchemaTree>> {
        private static final Equivalence<ValueHolder<SchemaTree>> INSTANCE = new SchemaHolderEquivalence();
        private static final Equivalence<SchemaTree> EQUIVALENCE = SchemaTreeEquivalence.getInstance();

        private SchemaHolderEquivalence() {
        }

        protected boolean doEquivalent(ValueHolder<SchemaTree> a, ValueHolder<SchemaTree> b) {
            return EQUIVALENCE.equivalent(a.getValue(), b.getValue());
        }

        protected int doHash(ValueHolder<SchemaTree> t) {
            return EQUIVALENCE.hash(t.getValue());
        }
    }
}

