/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.library;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.exceptions.unchecked.ValidationConfigurationError;
import com.github.fge.jsonschema.keyword.digest.Digester;
import com.github.fge.jsonschema.keyword.digest.helpers.IdentityDigester;
import com.github.fge.jsonschema.keyword.digest.helpers.SimpleDigester;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.library.Keyword;
import com.github.fge.jsonschema.messages.MessageBundle;
import com.github.fge.jsonschema.messages.ValidationBundles;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.util.Thawed;
import java.lang.reflect.Constructor;

public final class KeywordBuilder
implements Thawed<Keyword> {
    private static final MessageBundle BUNDLE = ValidationBundles.VALIDATION_CFG;
    final String name;
    SyntaxChecker syntaxChecker;
    Digester digester;
    Constructor<? extends KeywordValidator> constructor;

    KeywordBuilder(String name) {
        BUNDLE.checkNotNull(name, "nullName");
        this.name = name;
    }

    KeywordBuilder(Keyword keyword) {
        this.name = keyword.name;
        this.syntaxChecker = keyword.syntaxChecker;
        this.digester = keyword.digester;
        this.constructor = keyword.constructor;
    }

    public KeywordBuilder withSyntaxChecker(SyntaxChecker syntaxChecker) {
        BUNDLE.checkNotNull(syntaxChecker, "nullSyntaxChecker");
        this.syntaxChecker = syntaxChecker;
        return this;
    }

    public KeywordBuilder withDigester(Digester digester) {
        BUNDLE.checkNotNull(digester, "nullDigester");
        this.digester = digester;
        return this;
    }

    public KeywordBuilder withIdentityDigester(NodeType first, NodeType ... other) {
        this.digester = new IdentityDigester(this.name, KeywordBuilder.checkType(first), KeywordBuilder.checkTypes(other));
        return this;
    }

    public KeywordBuilder withSimpleDigester(NodeType first, NodeType ... other) {
        this.digester = new SimpleDigester(this.name, KeywordBuilder.checkType(first), KeywordBuilder.checkTypes(other));
        return this;
    }

    public KeywordBuilder withValidatorClass(Class<? extends KeywordValidator> c) {
        this.constructor = KeywordBuilder.getConstructor(c);
        return this;
    }

    public Keyword freeze() {
        return new Keyword(this);
    }

    private static Constructor<? extends KeywordValidator> getConstructor(Class<? extends KeywordValidator> c) {
        try {
            return c.getConstructor(JsonNode.class);
        }
        catch (NoSuchMethodException ignored) {
            throw new ValidationConfigurationError(new ProcessingMessage().message(BUNDLE.getString("noAppropriateConstructor")));
        }
    }

    private static NodeType checkType(NodeType type) {
        BUNDLE.checkNotNull(type, "nullType");
        return type;
    }

    private static NodeType[] checkTypes(NodeType ... types) {
        for (NodeType type : types) {
            BUNDLE.checkNotNull(type, "nullType");
        }
        return types;
    }
}

