/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.report;

import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.report.LogLevel;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;

public abstract class AbstractProcessingReport
implements ProcessingReport {
    protected LogLevel currentLevel = LogLevel.DEBUG;
    private LogLevel logLevel = LogLevel.INFO;
    private LogLevel exceptionThreshold = LogLevel.FATAL;

    protected AbstractProcessingReport() {
    }

    @Override
    public final void setLogLevel(LogLevel level) {
        this.logLevel = level;
    }

    @Override
    public final void setExceptionThreshold(LogLevel level) {
        this.exceptionThreshold = level;
    }

    @Override
    public final LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public final LogLevel getExceptionThreshold() {
        return this.exceptionThreshold;
    }

    @Override
    public final void debug(ProcessingMessage message) throws ProcessingException {
        this.log(message.setLogLevel(LogLevel.DEBUG));
    }

    @Override
    public final void info(ProcessingMessage message) throws ProcessingException {
        this.log(message.setLogLevel(LogLevel.INFO));
    }

    @Override
    public final void warn(ProcessingMessage message) throws ProcessingException {
        this.log(message.setLogLevel(LogLevel.WARNING));
    }

    @Override
    public final void error(ProcessingMessage message) throws ProcessingException {
        this.log(message.setLogLevel(LogLevel.ERROR));
    }

    @Override
    public final boolean isSuccess() {
        return this.currentLevel.compareTo(LogLevel.ERROR) < 0;
    }

    public abstract void doLog(ProcessingMessage var1);

    @Override
    public final void log(ProcessingMessage message) throws ProcessingException {
        LogLevel level = message.getLogLevel();
        if (level.compareTo(this.exceptionThreshold) >= 0) {
            throw message.asException();
        }
        if (level.compareTo(this.currentLevel) > 0) {
            this.currentLevel = level;
        }
        if (level.compareTo(this.logLevel) >= 0) {
            this.doLog(message.setLogLevel(level));
        }
    }

    @Override
    public final ProcessingMessage newMessage() {
        return new ProcessingMessage();
    }
}

