/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.ref;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.JsonReferenceException;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.load.SchemaLoader;
import com.github.fge.jsonschema.messages.RefProcessingMessages;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.ValidationContext;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;

public final class RefResolverProcessor
implements Processor<ValidationContext, ValidationContext> {
    private final SchemaLoader loader;

    public RefResolverProcessor(SchemaLoader loader) {
        this.loader = loader;
    }

    @Override
    public ValidationContext process(ProcessingReport report, ValidationContext input) throws ProcessingException {
        return input.withSchema(this.loadRef(input.getSchema()));
    }

    private static JsonRef nodeAsRef(JsonNode node) {
        JsonNode refNode = node.path("$ref");
        if (!refNode.isTextual()) {
            return null;
        }
        try {
            return JsonRef.fromString(refNode.textValue());
        }
        catch (JsonReferenceException ignored) {
            return null;
        }
    }

    private SchemaTree loadRef(SchemaTree orig) throws ProcessingException {
        JsonNode node;
        JsonRef ref;
        LinkedHashSet refs = Sets.newLinkedHashSet();
        SchemaTree tree = orig;
        ProcessingMessage message = new ProcessingMessage().put("schema", tree);
        while ((ref = RefResolverProcessor.nodeAsRef(node = tree.getNode())) != null) {
            JsonPointer ptr;
            if (!refs.add(ref = tree.resolve(ref))) {
                message.message(RefProcessingMessages.REF_LOOP).put("ref", ref).put("path", refs);
                throw new ProcessingException(message);
            }
            if (!tree.containsRef(ref)) {
                tree = this.loader.get(ref.getLocator());
            }
            if ((ptr = tree.matchingPointer(ref)) == null) {
                message.message(RefProcessingMessages.DANGLING_REF).put("ref", ref);
                throw new ProcessingException(message);
            }
            tree = tree.setPointer(ptr);
        }
        return tree;
    }

    public String toString() {
        return "ref resolver";
    }
}

