/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.data;

import com.github.fge.jsonschema.processors.data.ValidationData;
import com.github.fge.jsonschema.report.MessageProvider;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.tree.JsonTree;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.NodeType;

public final class ValidationContext
implements MessageProvider {
    private final SchemaTree schema;
    private final NodeType instanceType;

    public ValidationContext(ValidationData data) {
        this.schema = data.getSchema();
        JsonTree tree = data.getInstance();
        this.instanceType = tree != null ? NodeType.getNodeType(tree.getNode()) : null;
    }

    public ValidationContext(SchemaTree schema, NodeType instanceType) {
        this.schema = schema;
        this.instanceType = instanceType;
    }

    public SchemaTree getSchema() {
        return this.schema;
    }

    public NodeType getInstanceType() {
        return this.instanceType;
    }

    public ValidationContext withSchema(SchemaTree schemaTree) {
        return new ValidationContext(schemaTree, this.instanceType);
    }

    @Override
    public ProcessingMessage newMessage() {
        return new ProcessingMessage().put("schema", this.schema);
    }
}

