/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.ref;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.JsonReferenceException;
import com.github.fge.jsonschema.ref.IllegalFragment;
import com.github.fge.jsonschema.ref.JsonPointer;

public abstract class JsonFragment {
    protected final String asString;

    protected JsonFragment(String input) {
        this.asString = input;
    }

    public static JsonFragment fromFragment(String fragment) {
        if (fragment.isEmpty()) {
            return JsonPointer.empty();
        }
        try {
            return new JsonPointer(fragment);
        }
        catch (JsonReferenceException ignored) {
            return new IllegalFragment(fragment);
        }
    }

    public abstract JsonNode resolve(JsonNode var1);

    public abstract boolean isEmpty();

    public abstract boolean isPointer();

    public final int hashCode() {
        return this.asString.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonFragment)) {
            return false;
        }
        JsonFragment other = (JsonFragment)obj;
        return this.asString.equals(other.asString);
    }

    public final String toString() {
        return this.asString;
    }
}

