/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.FullValidationContext;
import com.github.fge.jsonschema.processors.data.ValidationData;
import com.github.fge.jsonschema.processors.ref.RefResolverProcessor;
import com.github.fge.jsonschema.processors.validation.ArraySchemaDigester;
import com.github.fge.jsonschema.processors.validation.ArraySchemaSelector;
import com.github.fge.jsonschema.processors.validation.ObjectSchemaDigester;
import com.github.fge.jsonschema.processors.validation.ObjectSchemaSelector;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.JsonTree;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public final class ValidationProcessor
implements Processor<ValidationData, ProcessingReport> {
    private final RefResolverProcessor refResolver;
    private final Processor<ValidationData, FullValidationContext> processor;
    private final LoadingCache<JsonNode, ArraySchemaSelector> arrayCache;
    private final LoadingCache<JsonNode, ObjectSchemaSelector> objectCache;

    public ValidationProcessor(RefResolverProcessor refResolver, Processor<ValidationData, FullValidationContext> processor) {
        this.refResolver = refResolver;
        this.processor = processor;
        this.arrayCache = CacheBuilder.newBuilder().build(ValidationProcessor.arrayLoader());
        this.objectCache = CacheBuilder.newBuilder().build(ValidationProcessor.objectLoader());
    }

    @Override
    public ProcessingReport process(ProcessingReport report, ValidationData input) throws ProcessingException {
        ValidationData resolved = this.refResolver.process(report, input);
        FullValidationContext context = this.processor.process(report, resolved);
        ValidationData data = context.getValidationData();
        for (KeywordValidator validator : context) {
            validator.validate(this, report, data);
        }
        if (!report.isSuccess()) {
            return report;
        }
        JsonNode node = resolved.getInstance().getNode();
        if (node.size() == 0) {
            return report;
        }
        if (node.isArray()) {
            this.processArray(report, resolved);
        } else {
            this.processObject(report, resolved);
        }
        return report;
    }

    private void processArray(ProcessingReport report, ValidationData resolved) throws ProcessingException {
        SchemaTree tree = resolved.getSchema();
        JsonTree instance = resolved.getInstance();
        JsonNode schema = tree.getNode();
        JsonNode node = instance.getNode();
        JsonNode digest = ArraySchemaDigester.getInstance().digest(schema);
        ArraySchemaSelector selector = (ArraySchemaSelector)this.arrayCache.getUnchecked((Object)digest);
        int size = node.size();
        for (int index = 0; index < size; ++index) {
            JsonTree newInstance = instance.append(JsonPointer.empty().append(index));
            ValidationData data = resolved.withInstance(newInstance);
            for (JsonPointer ptr : selector.selectSchemas(index)) {
                data = data.withSchema(tree.append(ptr));
                this.process(report, data);
            }
        }
    }

    private void processObject(ProcessingReport report, ValidationData resolved) throws ProcessingException {
        SchemaTree tree = resolved.getSchema();
        JsonTree instance = resolved.getInstance();
        JsonNode schema = tree.getNode();
        JsonNode node = instance.getNode();
        JsonNode digest = ObjectSchemaDigester.getInstance().digest(schema);
        ObjectSchemaSelector selector = (ObjectSchemaSelector)this.objectCache.getUnchecked((Object)digest);
        ArrayList fields = Lists.newArrayList((Iterator)node.fieldNames());
        Collections.sort(fields);
        for (String field : fields) {
            JsonTree newInstance = instance.append(JsonPointer.empty().append(field));
            ValidationData data = resolved.withInstance(newInstance);
            for (JsonPointer ptr : selector.selectSchemas(field)) {
                data = data.withSchema(tree.append(ptr));
                this.process(report, data);
            }
        }
    }

    private static CacheLoader<JsonNode, ArraySchemaSelector> arrayLoader() {
        return new CacheLoader<JsonNode, ArraySchemaSelector>(){

            public ArraySchemaSelector load(JsonNode key) throws Exception {
                return new ArraySchemaSelector(key);
            }
        };
    }

    private static CacheLoader<JsonNode, ObjectSchemaSelector> objectLoader() {
        return new CacheLoader<JsonNode, ObjectSchemaSelector>(){

            public ObjectSchemaSelector load(JsonNode key) throws Exception {
                return new ObjectSchemaSelector(key);
            }
        };
    }

    public String toString() {
        return "validation processor";
    }
}

