/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.validation;

import com.github.fge.jsonschema.exceptions.InvalidSchemaException;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ProcessorChain;
import com.github.fge.jsonschema.processing.ProcessorSelector;
import com.github.fge.jsonschema.processors.build.ValidatorBuilder;
import com.github.fge.jsonschema.processors.data.FullValidationContext;
import com.github.fge.jsonschema.processors.data.ValidationData;
import com.github.fge.jsonschema.processors.digest.SchemaDigester;
import com.github.fge.jsonschema.processors.format.FormatProcessor;
import com.github.fge.jsonschema.processors.syntax.SyntaxProcessor;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.google.common.base.Predicate;

public final class ValidationChain
implements Processor<ValidationData, FullValidationContext> {
    private final Processor<ValidationData, FullValidationContext> processor;

    public ValidationChain(Library library, boolean useFormat) {
        SyntaxProcessor syntaxProcessor = new SyntaxProcessor(library.getSyntaxCheckers());
        Processor<ValidationData, FullValidationContext> onSuccess = ValidationChain.mainProcessor(library, useFormat);
        ProcessorSelector<ValidationData, FullValidationContext> selector = new ProcessorSelector().when(ValidationChain.schemaIsValid()).then(onSuccess).otherwise(ValidationChain.onFailure());
        this.processor = ProcessorChain.startWith(syntaxProcessor).chainWith(selector.getProcessor()).getProcessor();
    }

    public ValidationChain(Library library) {
        this(library, true);
    }

    @Override
    public FullValidationContext process(ProcessingReport report, ValidationData input) throws ProcessingException {
        return this.processor.process(report, input);
    }

    private static Processor<ValidationData, FullValidationContext> onFailure() {
        return new Processor<ValidationData, FullValidationContext>(){

            @Override
            public FullValidationContext process(ProcessingReport report, ValidationData input) throws ProcessingException {
                ProcessingMessage message = input.newMessage().message(SyntaxMessages.INVALID_SCHEMA);
                throw new InvalidSchemaException(message);
            }
        };
    }

    private static Predicate<ValidationData> schemaIsValid() {
        return new Predicate<ValidationData>(){

            public boolean apply(ValidationData input) {
                return input.getSchema().isValid();
            }
        };
    }

    private static Processor<ValidationData, FullValidationContext> mainProcessor(Library library, boolean useFormat) {
        SchemaDigester digester = new SchemaDigester(library.getDigesters());
        ValidatorBuilder builder = new ValidatorBuilder(library.getValidators());
        ProcessorChain<ValidationData, FullValidationContext> chain = ProcessorChain.startWith(digester).chainWith(builder);
        if (useFormat) {
            FormatProcessor formatProcessor = new FormatProcessor(library.getFormatAttributes());
            chain = chain.chainWith(formatProcessor);
        }
        return chain.getProcessor();
    }

    public String toString() {
        return this.processor.toString();
    }
}

