/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.validator.helpers.DraftV3TypeKeywordValidator;
import com.github.fge.jsonschema.messages.KeywordValidationMessages;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.ValidationData;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.report.ListProcessingReport;
import com.github.fge.jsonschema.report.LogLevel;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.NodeType;
import java.util.Iterator;

public final class DisallowKeywordValidator
extends DraftV3TypeKeywordValidator {
    public DisallowKeywordValidator(JsonNode digested) {
        super("disallow", digested);
    }

    @Override
    public void validate(Processor<ValidationData, ProcessingReport> processor, ProcessingReport report, ValidationData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        NodeType type = NodeType.getNodeType(instance);
        if (this.types.contains((Object)type)) {
            report.error(this.newMsg(data).message(KeywordValidationMessages.DISALLOWED_TYPE).put("disallowed", this.types).put("found", type));
            return;
        }
        SchemaTree tree = data.getSchema();
        JsonPointer schemaPointer = tree.getPointer();
        ObjectNode fullReport = FACTORY.objectNode();
        int nrSuccess = 0;
        Iterator i$ = this.schemas.iterator();
        while (i$.hasNext()) {
            int index = (Integer)i$.next();
            ListProcessingReport subReport = new ListProcessingReport(report);
            subReport.setExceptionThreshold(LogLevel.FATAL);
            JsonPointer ptr = schemaPointer.append(this.basePtr.append(index));
            ValidationData newData = data.withSchema(tree.setPointer(ptr));
            processor.process(subReport, newData);
            fullReport.put(ptr.toString(), subReport.asJson());
            if (!subReport.isSuccess()) continue;
            ++nrSuccess;
        }
        if (nrSuccess != 0) {
            report.error(this.newMsg(data).message(KeywordValidationMessages.DISALLOW_SCHEMA).put("reports", (JsonNode)fullReport));
        }
    }
}

