/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.ValidatedPaths;
import com.github.fge.jsonschema.processors.data.ValidationData;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.report.ListProcessingReport;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class SyntaxProcessor
implements Processor<ValidationData, ValidationData> {
    private final Dictionary<SyntaxChecker> dict;
    private final LoadingCache<JsonNode, ValidatedPaths> cache;

    public SyntaxProcessor(Dictionary<SyntaxChecker> dict) {
        this.dict = dict;
        this.cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<JsonNode, ValidatedPaths>(){

            public ValidatedPaths load(JsonNode key) throws Exception {
                return new ValidatedPaths();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidationData process(ProcessingReport report, ValidationData input) throws ProcessingException {
        ValidatedPaths paths;
        SchemaTree schema = input.getSchema();
        ListProcessingReport syntaxReport = new ListProcessingReport(report);
        ValidatedPaths validatedPaths = paths = (ValidatedPaths)this.cache.getUnchecked((Object)schema.getBaseNode());
        synchronized (validatedPaths) {
            if (!paths.isValidated(schema.getPointer())) {
                this.validate(syntaxReport, schema, paths);
                paths.addReport(syntaxReport);
                if (paths.isValid()) {
                    paths.addValidatedPath(schema.getPointer());
                }
            }
        }
        for (ProcessingMessage message : syntaxReport.getMessages()) {
            report.log(message);
        }
        return input.withSchema(schema.withValidationStatus(paths.isValid()));
    }

    private void validate(ProcessingReport report, SchemaTree tree, ValidatedPaths paths) throws ProcessingException {
        JsonNode node = tree.getNode();
        NodeType type = NodeType.getNodeType(node);
        if (type != NodeType.OBJECT) {
            ProcessingMessage msg = SyntaxProcessor.newMsg(tree).message(SyntaxMessages.NOT_A_SCHEMA).put("found", type);
            report.error(msg);
            return;
        }
        HashSet fieldNames = Sets.newHashSet((Iterator)node.fieldNames());
        Set<String> ignored = this.dict.missingEntriesFrom(fieldNames);
        if (!ignored.isEmpty()) {
            JsonPointer pointer = tree.getPointer();
            for (String name : ignored) {
                paths.addUncheckedPath(pointer.append(name));
            }
            report.warn(SyntaxProcessor.newMsg(tree).message(SyntaxMessages.UNKNOWN_KEYWORDS).put("ignored", ignored));
        }
        ArrayList pointers = Lists.newArrayList();
        for (SyntaxChecker checker : this.dict.valuesForKeys(fieldNames)) {
            checker.checkSyntax(pointers, report, tree);
        }
        for (JsonPointer pointer : pointers) {
            this.validate(report, tree.append(pointer), paths);
        }
    }

    private static ProcessingMessage newMsg(SchemaTree tree) {
        return new ProcessingMessage().put("schema", tree).put("domain", "syntax");
    }

    public String toString() {
        return "syntax checker";
    }
}

