/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.ValidationData;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;

public final class ExtendsValidator
extends AbstractKeywordValidator {
    private static final JsonPointer BASE_PTR = JsonPointer.empty().append("extends");

    public ExtendsValidator(JsonNode digest) {
        super("extends");
    }

    @Override
    public void validate(Processor<ValidationData, ProcessingReport> processor, ProcessingReport report, ValidationData data) throws ProcessingException {
        SchemaTree tree = data.getSchema();
        JsonNode node = tree.getNode().get(this.keyword);
        if (node.isObject()) {
            ValidationData newData = data.withSchema(tree.append(BASE_PTR));
            processor.process(report, newData);
            return;
        }
        int size = node.size();
        for (int index = 0; index < size; ++index) {
            ValidationData newData = data.withSchema(tree.append(BASE_PTR.append(index)));
            processor.process(report, newData);
        }
    }

    @Override
    public String toString() {
        return this.keyword;
    }
}

