/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.crude;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.report.AbstractProcessingReport;
import com.github.fge.jsonschema.report.LogLevel;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.util.AsJson;
import com.github.fge.jsonschema.util.JacksonUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public final class UncheckedReport
extends AbstractProcessingReport
implements AsJson {
    private final List<ProcessingMessage> messages = Lists.newArrayList();

    UncheckedReport(ProcessingException e, ProcessingReport report) {
        this.currentLevel = LogLevel.FATAL;
        this.messages.add(e.getProcessingMessage().put("info", "other messages follow (if any)"));
        for (ProcessingMessage message : report.getMessages()) {
            this.messages.add(message);
        }
    }

    @Override
    public void doLog(ProcessingMessage message) {
    }

    @Override
    public List<ProcessingMessage> getMessages() {
        return ImmutableList.copyOf(this.messages);
    }

    @Override
    public JsonNode asJson() {
        ArrayNode ret = JacksonUtils.nodeFactory().arrayNode();
        for (ProcessingMessage message : this.messages) {
            ret.add(message.asJson());
        }
        return ret;
    }
}

