/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.digest;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.ValidationData;
import com.github.fge.jsonschema.processors.data.ValidationDigest;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.util.Digester;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class SchemaDigester
implements Processor<ValidationData, ValidationDigest> {
    private final ListMultimap<NodeType, String> typeMap = ArrayListMultimap.create();
    private final Map<String, Digester> digesterMap = Maps.newHashMap();
    private final LoadingCache<JsonNode, Map<String, JsonNode>> cache;

    public SchemaDigester(Dictionary<Digester> dict) {
        for (Map.Entry<String, Digester> entry : dict.entries()) {
            String keyword = entry.getKey();
            Digester digester = entry.getValue();
            this.digesterMap.put(keyword, digester);
            for (NodeType type : digester.supportedTypes()) {
                this.typeMap.put((Object)type, (Object)keyword);
            }
        }
        this.cache = CacheBuilder.newBuilder().recordStats().build(this.loader());
    }

    @Override
    public ValidationDigest process(ProcessingReport report, ValidationData input) throws ProcessingException {
        JsonNode schema = input.getSchema().getNode();
        NodeType type = NodeType.getNodeType(input.getInstance().getNode());
        HashMap map = Maps.newHashMap((Map)((Map)this.cache.getUnchecked((Object)schema)));
        map.keySet().retainAll(this.typeMap.get((Object)type));
        return new ValidationDigest(input, map);
    }

    private CacheLoader<JsonNode, Map<String, JsonNode>> loader() {
        return new CacheLoader<JsonNode, Map<String, JsonNode>>(){

            public Map<String, JsonNode> load(JsonNode key) throws ProcessingException {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                HashMap map = Maps.newHashMap((Map)SchemaDigester.this.digesterMap);
                map.keySet().retainAll(Sets.newHashSet((Iterator)key.fieldNames()));
                for (Map.Entry entry : map.entrySet()) {
                    builder.put(entry.getKey(), (Object)((Digester)entry.getValue()).digest(key));
                }
                return builder.build();
            }
        };
    }

    public String toString() {
        return this.cache.stats().toString();
    }
}

