/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.load;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.ref.JsonRef;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;

public final class SchemaBundle {
    private final Map<URI, JsonNode> schemas = Maps.newHashMap();

    public void addSchema(URI uri, JsonNode schema) {
        JsonRef ref = JsonRef.fromURI(uri);
        Preconditions.checkArgument((boolean)ref.isAbsolute(), (Object)("provided URI " + uri + " is not an absolute schema URI"));
        this.schemas.put(ref.getLocator(), schema);
    }

    public void addSchema(String uri, JsonNode schema) {
        this.addSchema(URI.create(uri), schema);
    }

    public Map<URI, JsonNode> getSchemas() {
        return ImmutableMap.copyOf(this.schemas);
    }
}

