/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.load;

import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.load.LoadingConfigurationBuilder;
import com.github.fge.jsonschema.load.URIDownloader;
import com.github.fge.jsonschema.util.Frozen;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;

public final class LoadingConfiguration
implements Frozen<LoadingConfigurationBuilder> {
    final Dictionary<URIDownloader> downloaders;
    final URI namespace;
    final Map<URI, URI> schemaRedirects;

    public static LoadingConfigurationBuilder newConfiguration() {
        return new LoadingConfigurationBuilder();
    }

    public static LoadingConfiguration byDefault() {
        return new LoadingConfigurationBuilder().freeze();
    }

    LoadingConfiguration(LoadingConfigurationBuilder cfg) {
        this.downloaders = cfg.downloaders.freeze();
        this.namespace = cfg.namespace;
        this.schemaRedirects = Maps.newHashMap(cfg.schemaRedirects);
    }

    public Dictionary<URIDownloader> downloaders() {
        return this.downloaders;
    }

    public Map<URI, URI> schemaRedirects() {
        return ImmutableMap.copyOf(this.schemaRedirects);
    }

    @Override
    public LoadingConfigurationBuilder thaw() {
        return new LoadingConfigurationBuilder(this);
    }
}

