/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class JacksonUtils {
    private static final JsonNodeFactory FACTORY = JsonNodeFactory.withExactBigDecimals((boolean)false);
    private static final JsonNode EMPTY_OBJECT = FACTORY.objectNode();
    private static final ObjectReader READER = new ObjectMapper().setNodeFactory(FACTORY).enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS).reader();

    private JacksonUtils() {
    }

    public static ObjectReader getReader() {
        return READER;
    }

    public static JsonNodeFactory nodeFactory() {
        return FACTORY;
    }

    public static JsonNode emptyObject() {
        return EMPTY_OBJECT;
    }

    public static Map<String, JsonNode> asMap(JsonNode node) {
        if (!node.isObject()) {
            return Collections.emptyMap();
        }
        Iterator iterator = node.fields();
        HashMap ret = Maps.newHashMap();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }
}

