/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.tree;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.ref.Dereferencing;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.JacksonUtils;

public abstract class BaseSchemaTree
implements SchemaTree {
    protected static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    protected final boolean valid;
    protected final JsonNode baseNode;
    protected final JsonPointer pointer;
    protected final JsonNode node;
    private final Dereferencing dereferencing;
    protected final JsonRef loadingRef;
    protected final JsonRef startingRef;
    protected JsonRef currentRef;

    protected BaseSchemaTree(JsonRef loadingRef, JsonNode baseNode, Dereferencing dereferencing) {
        this(loadingRef, baseNode, JsonPointer.empty(), dereferencing);
    }

    protected BaseSchemaTree(JsonRef loadingRef, JsonNode baseNode, JsonPointer pointer, Dereferencing dereferencing) {
        this(loadingRef, baseNode, pointer, dereferencing, false);
    }

    protected BaseSchemaTree(JsonRef loadingRef, JsonNode baseNode, JsonPointer pointer, Dereferencing dereferencing, boolean valid) {
        this.baseNode = baseNode;
        this.pointer = pointer;
        this.node = pointer.resolve(baseNode);
        this.dereferencing = dereferencing;
        this.loadingRef = loadingRef;
        JsonRef ref = BaseSchemaTree.idFromNode(baseNode);
        this.startingRef = ref == null ? loadingRef : loadingRef.resolve(ref);
        this.currentRef = BaseSchemaTree.nextRef(this.startingRef, pointer.asElements(), baseNode);
        this.valid = valid;
    }

    @Override
    public final JsonNode getBaseNode() {
        return this.baseNode;
    }

    @Override
    public final JsonPointer getPointer() {
        return this.pointer;
    }

    @Override
    public final JsonNode getNode() {
        return this.node;
    }

    @Override
    public final JsonRef resolve(JsonRef other) {
        return this.currentRef.resolve(other);
    }

    @Override
    public final JsonRef getLoadingRef() {
        return this.loadingRef;
    }

    @Override
    public final JsonRef getContext() {
        return this.currentRef;
    }

    @Override
    public final boolean isValid() {
        return this.valid;
    }

    protected static JsonRef idFromNode(JsonNode node) {
        if (!node.path("id").isTextual()) {
            return null;
        }
        try {
            return JsonRef.fromString(node.get("id").textValue());
        }
        catch (ProcessingException ignored) {
            return null;
        }
    }

    protected static JsonRef nextRef(JsonRef startingRef, Iterable<JsonPointer> pointers, JsonNode startingNode) {
        JsonRef ret = startingRef;
        JsonNode node = startingNode;
        for (JsonPointer pointer : pointers) {
            node = pointer.resolve(node);
            JsonRef idRef = BaseSchemaTree.idFromNode(node);
            if (idRef == null) continue;
            ret = ret.resolve(idRef);
        }
        return ret;
    }

    @Override
    public final JsonNode asJson() {
        ObjectNode ret = FACTORY.objectNode();
        ret.put("loadingURI", (JsonNode)FACTORY.textNode(this.loadingRef.toString()));
        ret.put("pointer", (JsonNode)FACTORY.textNode(this.pointer.toString()));
        ret.put("currentContext", (JsonNode)FACTORY.textNode(this.currentRef.toString()));
        ret.put("dereferencing", (JsonNode)FACTORY.textNode(this.dereferencing.toString()));
        return ret;
    }

    public final String toString() {
        return this.asJson().toString();
    }
}

