/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.report;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.github.fge.jsonschema.processing.LogLevel;
import com.github.fge.jsonschema.report.AbstractProcessingReport;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.util.AsJson;
import com.github.fge.jsonschema.util.JacksonUtils;
import com.google.common.collect.Lists;
import java.util.List;

public class ListProcessingReport
extends AbstractProcessingReport
implements AsJson {
    private static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    protected final List<ProcessingMessage> messages = Lists.newArrayList();

    public ListProcessingReport() {
    }

    public ListProcessingReport(ProcessingReport other) {
        LogLevel level = other.getLogLevel();
        if (level != null) {
            this.setLogLevel(level);
        }
        if ((level = other.getExceptionThreshold()) != null) {
            this.setExceptionThreshold(level);
        }
    }

    @Override
    public final void doLog(ProcessingMessage message) {
        this.messages.add(message);
    }

    @Override
    public final JsonNode asJson() {
        ArrayNode ret = FACTORY.arrayNode();
        for (ProcessingMessage message : this.messages) {
            ret.add(message.asJson());
        }
        return ret;
    }

    @Override
    public final List<ProcessingMessage> getMessages() {
        return Lists.newArrayList(this.messages);
    }
}

