/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.ref;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.ref.JsonFragment;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.google.common.base.CharMatcher;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;

public final class JsonPointer
extends JsonFragment {
    private static final JsonPointer EMPTY = new JsonPointer("", (List<String>)ImmutableList.of());
    private static final CharMatcher SLASH = CharMatcher.is((char)'/');
    private static final CharMatcher ESCAPE_CHAR = CharMatcher.is((char)'~');
    private static final CharMatcher ZERO = CharMatcher.is((char)'0');
    private static final BiMap<Character, Character> ESCAPE_REPLACEMENT_MAP = new ImmutableBiMap.Builder().put((Object)Character.valueOf('0'), (Object)Character.valueOf('~')).put((Object)Character.valueOf('1'), (Object)Character.valueOf('/')).build();
    private static final CharMatcher ESCAPED;
    private static final CharMatcher SPECIAL;
    private final List<String> refTokens;

    public static JsonPointer empty() {
        return EMPTY;
    }

    public JsonPointer(String input) throws ProcessingException {
        super(input);
        ImmutableList.Builder builder = ImmutableList.builder();
        JsonPointer.decode(input, (ImmutableList.Builder<String>)builder);
        this.refTokens = builder.build();
    }

    private JsonPointer(String fullPointer, List<String> refTokens) {
        super(fullPointer);
        this.refTokens = refTokens;
    }

    private static JsonPointer fromElements(List<String> refTokens) {
        if (refTokens.isEmpty()) {
            return JsonPointer.empty();
        }
        StringBuilder sb = new StringBuilder();
        for (String raw : refTokens) {
            sb.append('/').append(JsonPointer.refTokenEncode(raw));
        }
        return new JsonPointer(sb.toString(), refTokens);
    }

    public JsonPointer append(JsonPointer other) {
        ImmutableList newElements = ImmutableList.builder().addAll(this.refTokens).addAll(other.refTokens).build();
        if (newElements.isEmpty()) {
            return JsonPointer.empty();
        }
        String newPath = this.asString + other.asString;
        return new JsonPointer(newPath, (List<String>)newElements);
    }

    public JsonPointer append(String element) {
        ImmutableList newElements = ImmutableList.builder().addAll(this.refTokens).add((Object)element).build();
        return new JsonPointer(this.asString + '/' + JsonPointer.refTokenEncode(element), (List<String>)newElements);
    }

    public JsonPointer append(int index) {
        return this.append(Integer.toString(index));
    }

    @Override
    public JsonNode resolve(JsonNode node) {
        JsonNode ret = node;
        for (String pathElement : this.refTokens) {
            if (!ret.isContainerNode()) {
                return MissingNode.getInstance();
            }
            if (!(ret = ret.isObject() ? ret.path(pathElement) : ret.path(JsonPointer.arrayIndexFor(pathElement))).isMissingNode()) continue;
            break;
        }
        return ret;
    }

    @Override
    public boolean isEmpty() {
        return this.asString.isEmpty();
    }

    @Override
    public boolean isPointer() {
        return true;
    }

    public List<JsonPointer> asElements() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String raw : this.refTokens) {
            builder.add((Object)JsonPointer.fromElements((List<String>)ImmutableList.of((Object)raw)));
        }
        return builder.build();
    }

    public boolean isParentOf(JsonPointer other) {
        return Collections.indexOfSubList(other.refTokens, this.refTokens) == 0;
    }

    public JsonPointer relativize(JsonPointer other) {
        if (!this.isParentOf(other)) {
            return other;
        }
        List<String> list = other.refTokens.subList(this.refTokens.size(), other.refTokens.size());
        return JsonPointer.fromElements(list);
    }

    private static void decode(String input, ImmutableList.Builder<String> builder) throws ProcessingException {
        String victim = input;
        while (!victim.isEmpty()) {
            if (!victim.startsWith("/")) {
                ProcessingMessage message = new ProcessingMessage().msg("illegal JSON Pointer").put("reason", "reference token not preceeded by '/'");
                throw new ProcessingException(message);
            }
            victim = victim.substring(1);
            String cooked = JsonPointer.getNextRefToken(victim);
            victim = victim.substring(cooked.length());
            String raw = JsonPointer.refTokenDecode(cooked);
            builder.add((Object)raw);
        }
    }

    private static String getNextRefToken(String input) throws ProcessingException {
        StringBuilder sb = new StringBuilder();
        char[] array = input.toCharArray();
        boolean inEscape = false;
        for (char c : array) {
            if (inEscape) {
                if (!ESCAPED.matches(c)) {
                    ProcessingMessage message = new ProcessingMessage().msg("illegal JSON Pointer").put("reason", "bad escape sequence: '~' not followed by a valid token").put("allowed", ESCAPE_REPLACEMENT_MAP.keySet()).put("found", Character.valueOf(c));
                    throw new ProcessingException(message);
                }
                sb.append(c);
                inEscape = false;
                continue;
            }
            if (SLASH.matches(c)) break;
            if (ESCAPE_CHAR.matches(c)) {
                inEscape = true;
            }
            sb.append(c);
        }
        if (inEscape) {
            ProcessingMessage message = new ProcessingMessage().msg("illegal JSON Pointer").put("reason", "bad escape sequence: '~' not followed by any token");
            throw new ProcessingException(message);
        }
        return sb.toString();
    }

    private static String refTokenDecode(String cooked) {
        StringBuilder sb = new StringBuilder(cooked.length());
        char[] array = cooked.toCharArray();
        boolean inEscape = false;
        for (char c : array) {
            if (ESCAPE_CHAR.matches(c)) {
                inEscape = true;
                continue;
            }
            if (inEscape) {
                sb.append(ESCAPE_REPLACEMENT_MAP.get((Object)Character.valueOf(c)));
                inEscape = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String refTokenEncode(String raw) {
        char[] array;
        StringBuilder sb = new StringBuilder(raw.length());
        for (char c : array = raw.toCharArray()) {
            if (SPECIAL.matches(c)) {
                sb.append('~').append(ESCAPE_REPLACEMENT_MAP.inverse().get((Object)Character.valueOf(c)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static int arrayIndexFor(String pathElement) {
        if (pathElement.isEmpty()) {
            return -1;
        }
        if (ZERO.matches(pathElement.charAt(0))) {
            return pathElement.length() == 1 ? 0 : -1;
        }
        try {
            return Integer.parseInt(pathElement);
        }
        catch (NumberFormatException ignored) {
            return -1;
        }
    }

    static {
        CharMatcher escaped = CharMatcher.NONE;
        CharMatcher special = CharMatcher.NONE;
        for (Character c1 : ESCAPE_REPLACEMENT_MAP.keySet()) {
            escaped = escaped.or(CharMatcher.is((char)c1.charValue()));
        }
        for (Character c2 : ESCAPE_REPLACEMENT_MAP.values()) {
            special = special.or(CharMatcher.is((char)c2.charValue()));
        }
        ESCAPED = escaped.precomputed();
        SPECIAL = special.precomputed();
    }
}

