/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processing.selector;

import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.selector.ProcessorSelectorPredicate;
import com.github.fge.jsonschema.report.MessageProvider;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.Map;

public final class ProcessorSelector<IN extends MessageProvider, OUT extends MessageProvider> {
    final Map<Predicate<IN>, Processor<IN, OUT>> choices;
    private final Processor<IN, OUT> byDefault;

    public ProcessorSelector() {
        this.choices = Maps.newLinkedHashMap();
        this.byDefault = null;
    }

    private ProcessorSelector(Map<Predicate<IN>, Processor<IN, OUT>> choices, Processor<IN, OUT> byDefault) {
        this.choices = Maps.newLinkedHashMap(choices);
        this.byDefault = byDefault;
    }

    ProcessorSelector(ProcessorSelectorPredicate<IN, OUT> selector) {
        this(selector.choices, selector.byDefault);
    }

    public ProcessorSelectorPredicate<IN, OUT> when(Predicate<IN> predicate) {
        return new ProcessorSelectorPredicate<IN, OUT>(this, predicate, this.byDefault);
    }

    public ProcessorSelector<IN, OUT> otherwise(Processor<IN, OUT> byDefault) {
        return new ProcessorSelector<IN, OUT>(this.choices, byDefault);
    }

    public Processor<IN, OUT> getProcessor() {
        return this.buildChooser();
    }

    private Processor<IN, OUT> buildChooser() {
        return new Processor<IN, OUT>(){

            @Override
            public OUT process(ProcessingReport report, IN input) throws ProcessingException {
                for (Predicate predicate : ProcessorSelector.this.choices.keySet()) {
                    if (!predicate.apply(input)) continue;
                    return ProcessorSelector.this.choices.get(predicate).process(report, input);
                }
                if (ProcessorSelector.this.byDefault == null) {
                    throw new ProcessingException("no suitable processor found");
                }
                return ProcessorSelector.this.byDefault.process(report, input);
            }
        };
    }
}

