/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.library.syntax;

import com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.common.AdditionalSyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.common.EnumSyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.common.ExclusiveMaximumSyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.common.ExclusiveMinimumSyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.common.PatternPropertiesSyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.common.PatternSyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.helpers.PositiveIntegerSyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.helpers.TypeOnlySyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.helpers.URISyntaxChecker;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.library.DictionaryBuilder;
import com.github.fge.jsonschema.util.NodeType;

public final class CommonSyntaxCheckerDictionary {
    private static final Dictionary<SyntaxChecker> DICTIONARY;

    public static Dictionary<SyntaxChecker> get() {
        return DICTIONARY;
    }

    private CommonSyntaxCheckerDictionary() {
    }

    static {
        DictionaryBuilder<AdditionalSyntaxChecker> dict = Dictionary.newBuilder();
        String keyword = "additionalItems";
        SyntaxChecker checker = new AdditionalSyntaxChecker(keyword);
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        keyword = "minItems";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        keyword = "maxItems";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        keyword = "uniqueItems";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.BOOLEAN, new NodeType[0]);
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        keyword = "minimum";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.INTEGER, NodeType.NUMBER);
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        keyword = "exclusiveMinimum";
        checker = ExclusiveMinimumSyntaxChecker.getInstance();
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        keyword = "maximum";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.INTEGER, NodeType.NUMBER);
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        keyword = "exclusiveMaximum";
        checker = ExclusiveMaximumSyntaxChecker.getInstance();
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        keyword = "additionalProperties";
        checker = new AdditionalSyntaxChecker(keyword);
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        keyword = "patternProperties";
        checker = PatternPropertiesSyntaxChecker.getInstance();
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        keyword = "required";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.BOOLEAN, new NodeType[0]);
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        keyword = "minLength";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        keyword = "maxLength";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        keyword = "pattern";
        checker = PatternSyntaxChecker.getInstance();
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        keyword = "$schema";
        checker = new URISyntaxChecker(keyword);
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        keyword = "$ref";
        checker = new URISyntaxChecker(keyword);
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        keyword = "id";
        checker = new URISyntaxChecker(keyword);
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        keyword = "description";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.STRING, new NodeType[0]);
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        keyword = "title";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.STRING, new NodeType[0]);
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        keyword = "enum";
        checker = EnumSyntaxChecker.getInstance();
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        keyword = "format";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.STRING, new NodeType[0]);
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        keyword = "default";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.ARRAY, NodeType.values());
        dict.addEntry(keyword, (AdditionalSyntaxChecker)checker);
        DICTIONARY = dict.freeze();
    }
}

