/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.library;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.library.DraftV3Library;
import com.github.fge.jsonschema.library.DraftV4Library;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.ValidationData;
import com.github.fge.jsonschema.ref.JsonRef;
import com.google.common.base.Predicate;

public enum SchemaVersion {
    DRAFTV4("http://json-schema.org/draft-04/schema#", DraftV4Library.get()),
    DRAFTV3("http://json-schema.org/draft-03/schema#", DraftV3Library.get());

    private final JsonRef location;
    private final Library library;

    private SchemaVersion(String uri, Library library) {
        try {
            this.location = JsonRef.fromString(uri);
        }
        catch (ProcessingException e) {
            throw new ExceptionInInitializerError(e);
        }
        this.library = library;
    }

    public JsonRef getLocation() {
        return this.location;
    }

    public Library getLibrary() {
        return this.library;
    }

    public Predicate<ValidationData> versionTest() {
        return new Predicate<ValidationData>(){

            public boolean apply(ValidationData input) {
                return SchemaVersion.this.versionMatches(input.getSchema().getBaseNode());
            }
        };
    }

    private boolean versionMatches(JsonNode schema) {
        JsonNode node = schema.path("$schema");
        if (!node.isTextual()) {
            return false;
        }
        try {
            return this.location.equals(JsonRef.fromString(node.textValue()));
        }
        catch (ProcessingException ignored) {
            return false;
        }
    }
}

