/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.keyword.validator.helpers.DraftV3TypeKeywordValidator;
import com.github.fge.jsonschema.messages.KeywordValidationMessages;
import com.github.fge.jsonschema.processing.LogLevel;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ValidationData;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.report.ListProcessingReport;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.NodeType;
import java.util.Iterator;

public final class DraftV3TypeValidator
extends DraftV3TypeKeywordValidator {
    public DraftV3TypeValidator(JsonNode digest) {
        super("type", digest);
    }

    @Override
    public void validate(Processor<ValidationData, ProcessingReport> processor, ProcessingReport report, ValidationData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        NodeType type = NodeType.getNodeType(instance);
        boolean primitiveOK = this.types.contains((Object)type);
        if (primitiveOK) {
            return;
        }
        ObjectNode fullReport = FACTORY.objectNode();
        SchemaTree tree = data.getSchema();
        int nrSuccess = 0;
        Iterator i$ = this.schemas.iterator();
        while (i$.hasNext()) {
            int index = (Integer)i$.next();
            ListProcessingReport subReport = new ListProcessingReport(report);
            subReport.setExceptionThreshold(LogLevel.FATAL);
            JsonPointer ptr = this.basePtr.append(index);
            ValidationData newData = data.withSchema(tree.append(ptr));
            processor.process(subReport, newData);
            fullReport.put(ptr.toString(), subReport.asJson());
            if (!subReport.isSuccess()) continue;
            ++nrSuccess;
        }
        if (nrSuccess >= 1) {
            return;
        }
        if (!this.types.isEmpty()) {
            report.error(this.newMsg(data).msg(KeywordValidationMessages.TYPE_NO_MATCH).put("expected", this.types).put("found", type));
        }
        if (!this.schemas.isEmpty()) {
            report.error(this.newMsg(data).msg(KeywordValidationMessages.ANYOF_FAIL).put("reports", (JsonNode)fullReport));
        }
    }
}

