/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.messages.KeywordValidationMessages;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ValidationData;
import com.github.fge.jsonschema.report.ProcessingReport;

public final class AdditionalItemsValidator
extends AbstractKeywordValidator {
    private final boolean additionalOK;
    private final int itemsSize;

    public AdditionalItemsValidator(JsonNode digest) {
        super("additionalItems");
        this.additionalOK = digest.get(this.keyword).booleanValue();
        this.itemsSize = digest.get("itemsSize").intValue();
    }

    @Override
    public void validate(Processor<ValidationData, ProcessingReport> processor, ProcessingReport report, ValidationData data) throws ProcessingException {
        if (this.additionalOK) {
            return;
        }
        int size = data.getInstance().getNode().size();
        if (size > this.itemsSize) {
            report.error(this.newMsg(data).msg(KeywordValidationMessages.ADDITIONAL_ITEMS_NOT_ALLOWED).put("allowed", this.itemsSize).put("found", size));
        }
    }

    @Override
    public String toString() {
        return this.keyword + ": " + (this.additionalOK ? "allowed" : this.itemsSize + " max");
    }
}

