/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.syntax.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public abstract class SchemaMapSyntaxChecker
extends AbstractSyntaxChecker {
    private final JsonPointer basePointer;

    protected SchemaMapSyntaxChecker(String keyword) {
        super(keyword, NodeType.OBJECT, new NodeType[0]);
        this.basePointer = JsonPointer.empty().append(keyword);
    }

    @Override
    protected final void checkValue(Collection<JsonPointer> pointers, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        this.collectPointers(pointers, this.getNode(tree));
        this.extraChecks(report, tree);
    }

    protected abstract void extraChecks(ProcessingReport var1, SchemaTree var2) throws ProcessingException;

    private void collectPointers(Collection<JsonPointer> pointers, JsonNode node) {
        HashSet set = Sets.newHashSet((Iterator)node.fieldNames());
        for (String s : Ordering.natural().sortedCopy((Iterable)set)) {
            pointers.add(this.basePointer.append(s));
        }
    }
}

