/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.messages.FormatMessages;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.ValidationData;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.util.NodeType;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class DateFormatAttribute
extends AbstractFormatAttribute {
    protected final String format;
    protected final DateTimeFormatter formatter;

    protected DateFormatAttribute(String fmt, String format) {
        super(fmt, NodeType.STRING, new NodeType[0]);
        this.format = format;
        this.formatter = DateTimeFormat.forPattern((String)format);
    }

    @Override
    public final void validate(ProcessingReport report, ValidationData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        try {
            this.formatter.parseDateTime(instance.textValue());
        }
        catch (IllegalArgumentException ignored) {
            report.error(this.newMsg(data, FormatMessages.INVALID_DATE_FORMAT).put("expected", this.format));
        }
    }
}

