/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format;

import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.processing.ValidationData;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.util.NodeType;
import java.util.EnumSet;

public abstract class AbstractFormatAttribute
implements FormatAttribute {
    private final EnumSet<NodeType> supported;
    private final String fmt;

    protected AbstractFormatAttribute(String fmt, NodeType first, NodeType ... other) {
        this.fmt = fmt;
        this.supported = EnumSet.of(first, other);
    }

    @Override
    public final EnumSet<NodeType> supportedTypes() {
        return EnumSet.copyOf(this.supported);
    }

    protected final <T> ProcessingMessage newMsg(ValidationData data, T message) {
        return data.newMessage().put("domain", "validation").put("keyword", "format").put("attribute", this.fmt).msg(message).put("value", data.getInstance().getNode());
    }
}

