/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.crude;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.crude.UncheckedReport;
import com.github.fge.jsonschema.library.DraftV3Library;
import com.github.fge.jsonschema.library.DraftV4Library;
import com.github.fge.jsonschema.library.SchemaVersion;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ProcessorChain;
import com.github.fge.jsonschema.processing.ValidationData;
import com.github.fge.jsonschema.processing.build.FullValidationContext;
import com.github.fge.jsonschema.processing.ref.Dereferencing;
import com.github.fge.jsonschema.processing.ref.RefResolverProcessor;
import com.github.fge.jsonschema.processing.ref.SchemaBundle;
import com.github.fge.jsonschema.processing.ref.SchemaLoader;
import com.github.fge.jsonschema.processing.ref.URIManager;
import com.github.fge.jsonschema.processing.selector.ProcessorSelector;
import com.github.fge.jsonschema.processing.validation.ValidationChain;
import com.github.fge.jsonschema.processing.validation.ValidationProcessor;
import com.github.fge.jsonschema.report.ListProcessingReport;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.tree.SimpleJsonTree2;
import com.github.fge.jsonschema.uri.DefaultURIDownloader;
import com.github.fge.jsonschema.util.JsonLoader;
import java.io.IOException;
import java.net.URI;

public final class CrudeValidator {
    private final SchemaLoader loader;
    private final Processor<ValidationData, ProcessingReport> validator;

    public CrudeValidator(SchemaVersion version, Dereferencing dereferencing) throws IOException {
        URIManager manager = new URIManager();
        manager.unregisterScheme("file");
        manager.unregisterScheme("resource");
        manager.unregisterScheme("jar");
        manager.registerScheme("https", DefaultURIDownloader.getInstance());
        this.loader = new SchemaLoader(manager, URI.create("#"), dereferencing);
        SchemaBundle bundle = new SchemaBundle();
        bundle.addSchema(SchemaVersion.DRAFTV4.getLocation().toURI(), JsonLoader.fromResource("/draftv4/schema"));
        bundle.addSchema(SchemaVersion.DRAFTV3.getLocation().toURI(), JsonLoader.fromResource("/draftv3/schema"));
        this.loader.addBundle(bundle);
        RefResolverProcessor refResolver = new RefResolverProcessor(this.loader);
        ValidationChain draftv4 = new ValidationChain(DraftV4Library.get());
        ValidationChain draftv3 = new ValidationChain(DraftV3Library.get());
        ValidationChain byDefault = version == SchemaVersion.DRAFTV4 ? draftv4 : draftv3;
        Processor<ValidationData, FullValidationContext> processor = new ProcessorSelector().when(SchemaVersion.DRAFTV4.versionTest()).then(draftv4).when(SchemaVersion.DRAFTV3.versionTest()).then(draftv3).otherwise(byDefault).getProcessor();
        Processor<ValidationData, FullValidationContext> fullChain = ProcessorChain.startWith(refResolver).chainWith(processor).end();
        this.validator = new ValidationProcessor(fullChain);
    }

    public ProcessingReport validate(JsonNode schema, JsonNode instance) throws ProcessingException {
        ValidationData data = this.buildData(schema, instance);
        ListProcessingReport report = new ListProcessingReport();
        return this.validator.process(report, data);
    }

    public ProcessingReport validateUnchecked(JsonNode schema, JsonNode instance) {
        ValidationData data = this.buildData(schema, instance);
        ListProcessingReport report = new ListProcessingReport();
        try {
            return this.validator.process(report, data);
        }
        catch (ProcessingException e) {
            return new UncheckedReport(e, report);
        }
    }

    private ValidationData buildData(JsonNode schema, JsonNode node) {
        SchemaTree tree = this.loader.load(schema);
        SimpleJsonTree2 instance = new SimpleJsonTree2(node);
        return new ValidationData(tree, instance);
    }
}

