/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.old.syntax.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.old.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.old.syntax.SyntaxChecker;
import com.github.fge.jsonschema.old.syntax.SyntaxValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class DraftV4PropertiesSyntaxChecker
extends AbstractSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new DraftV4PropertiesSyntaxChecker();

    private DraftV4PropertiesSyntaxChecker() {
        super("properties", NodeType.OBJECT, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        HashSet fields = Sets.newHashSet((Iterator)node.fieldNames());
        Message.Builder msg = this.newMsg();
        for (String field : Ordering.natural().sortedCopy((Iterable)fields)) {
            msg.addInfo("key", field);
            JsonNode element = node.get(field);
            NodeType type = NodeType.getNodeType(element);
            if (type != NodeType.OBJECT) {
                msg.setMessage("key value has incorrect type").addInfo("expected", NodeType.OBJECT).addInfo("found", type);
                messages.add(msg.build());
                continue;
            }
            validator.validate(messages, element);
        }
    }
}

