/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.old.keyword.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.old.keyword.KeywordValidator;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.validator.JsonValidator;
import com.github.fge.jsonschema.validator.ValidationContext;

public final class NotKeywordValidator
extends KeywordValidator {
    private final JsonNode subSchema;

    public NotKeywordValidator(JsonNode schema) {
        super("not", NodeType.values());
        this.subSchema = schema.get(this.keyword);
    }

    @Override
    protected void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        ValidationReport subReport = new ValidationReport();
        JsonValidator validator = context.newValidator(this.subSchema);
        validator.validate(context, subReport, instance);
        if (subReport.isSuccess()) {
            report.addMessage(this.newMsg().setMessage("instance validates against a forbidden schema").build());
            return;
        }
        if (subReport.hasFatalError()) {
            report.mergeWith(subReport);
        }
    }

    @Override
    public String toString() {
        return "not: must not match enclosed schema";
    }
}

