/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.old.keyword.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.old.keyword.KeywordValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.validator.ValidationContext;
import java.util.EnumSet;

public final class DraftV4TypeKeywordValidator
extends KeywordValidator {
    private final EnumSet<NodeType> expected = EnumSet.noneOf(NodeType.class);

    public DraftV4TypeKeywordValidator(JsonNode schema) {
        super("type", NodeType.values());
        JsonNode typeNode = schema.get(this.keyword);
        if (typeNode.isTextual()) {
            this.addSimpleType(typeNode);
            return;
        }
        for (JsonNode node : typeNode) {
            this.addSimpleType(node);
        }
    }

    @Override
    protected void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        NodeType type = NodeType.getNodeType(instance);
        if (this.expected.contains((Object)type)) {
            return;
        }
        Message msg = this.newMsg().setMessage("instance has incorrect type").addInfo("found", type).addInfo("expected", this.expected).build();
        report.addMessage(msg);
    }

    @Override
    public String toString() {
        return "type: " + this.expected;
    }

    private void addSimpleType(JsonNode node) {
        NodeType type = NodeType.fromName(node.textValue());
        this.expected.add(type);
        if (type == NodeType.NUMBER) {
            this.expected.add(NodeType.INTEGER);
        }
    }
}

