/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.library.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.keyword.validator.common.DependenciesKeywordValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.AllOfKeywordValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.AnyOfKeywordValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.DraftV4TypeKeywordValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.MaxPropertiesKeywordValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.MinPropertiesKeywordValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.MultipleOfKeywordValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.NotKeywordValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.OneOfKeywordValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.RequiredKeywordValidator;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.library.DictionaryBuilder;
import com.github.fge.jsonschema.library.validator.CommonValidatorDictionary;
import java.lang.reflect.Constructor;

public final class DraftV4ValidatorDictionary {
    private static final Dictionary<Constructor<? extends KeywordValidator>> DICTIONARY;

    private DraftV4ValidatorDictionary() {
    }

    public static Dictionary<Constructor<? extends KeywordValidator>> get() {
        return DICTIONARY;
    }

    private static Constructor<? extends KeywordValidator> constructor(Class<? extends KeywordValidator> c) {
        try {
            return c.getConstructor(JsonNode.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No appropriate constructor found", e);
        }
    }

    static {
        DictionaryBuilder<Constructor<? extends KeywordValidator>> builder = Dictionary.newBuilder();
        builder.addAll(CommonValidatorDictionary.get());
        String keyword = "multipleOf";
        Class c = MultipleOfKeywordValidator.class;
        builder.addEntry(keyword, DraftV4ValidatorDictionary.constructor(c));
        keyword = "minProperties";
        c = MinPropertiesKeywordValidator.class;
        builder.addEntry(keyword, DraftV4ValidatorDictionary.constructor(c));
        keyword = "maxProperties";
        c = MaxPropertiesKeywordValidator.class;
        builder.addEntry(keyword, DraftV4ValidatorDictionary.constructor(c));
        keyword = "required";
        c = RequiredKeywordValidator.class;
        builder.addEntry(keyword, DraftV4ValidatorDictionary.constructor(c));
        keyword = "dependencies";
        c = DependenciesKeywordValidator.class;
        builder.addEntry(keyword, DraftV4ValidatorDictionary.constructor(c));
        keyword = "anyOf";
        c = AnyOfKeywordValidator.class;
        builder.addEntry(keyword, DraftV4ValidatorDictionary.constructor(c));
        keyword = "allOf";
        c = AllOfKeywordValidator.class;
        builder.addEntry(keyword, DraftV4ValidatorDictionary.constructor(c));
        keyword = "oneOf";
        c = OneOfKeywordValidator.class;
        builder.addEntry(keyword, DraftV4ValidatorDictionary.constructor(c));
        keyword = "not";
        c = NotKeywordValidator.class;
        builder.addEntry(keyword, DraftV4ValidatorDictionary.constructor(c));
        keyword = "type";
        c = DraftV4TypeKeywordValidator.class;
        builder.addEntry(keyword, DraftV4ValidatorDictionary.constructor(c));
        DICTIONARY = builder.freeze();
    }
}

