/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.library;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.library.Keyword;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.util.Thawed;
import com.github.fge.jsonschema.util.equivalence.JsonSchemaEquivalence;
import com.google.common.base.Equivalence;
import java.util.EnumSet;

public final class KeywordBuilder
implements Thawed<Keyword> {
    final String name;
    SyntaxChecker syntaxChecker;
    Class<? extends KeywordValidator> validatorClass;
    EnumSet<NodeType> types = EnumSet.allOf(NodeType.class);
    Equivalence<JsonNode> equivalence = JsonSchemaEquivalence.getInstance();

    KeywordBuilder(String name) {
        this.name = name;
    }

    KeywordBuilder(Keyword keyword) {
        this.name = keyword.name;
        this.syntaxChecker = keyword.syntaxChecker;
        this.equivalence = keyword.equivalence;
        this.types = EnumSet.copyOf(keyword.types);
        this.validatorClass = keyword.validatorClass;
    }

    @Override
    public Keyword freeze() {
        return new Keyword(this);
    }
}

