/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.messages.KeywordValidationMessages;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ValidationData;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.util.NodeType;
import java.util.EnumSet;

public final class DraftV4TypeKeywordValidator
extends AbstractKeywordValidator {
    private final EnumSet<NodeType> types = EnumSet.noneOf(NodeType.class);

    public DraftV4TypeKeywordValidator(JsonNode digest) {
        super("type");
        for (JsonNode node : digest.get(this.keyword)) {
            this.types.add(NodeType.fromName(node.textValue()));
        }
    }

    @Override
    public void validate(Processor<ValidationData, ProcessingReport> processor, ProcessingReport report, ValidationData data) throws ProcessingException {
        NodeType type = NodeType.getNodeType(data.getInstance().getCurrentNode());
        if (!this.types.contains((Object)type)) {
            report.error(this.newMsg(data).msg(KeywordValidationMessages.TYPE_NO_MATCH).put("expected", this.types).put("found", type));
        }
    }

    @Override
    public String toString() {
        return this.keyword + ": " + this.types;
    }
}

