/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.library.syntax;

import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.library.MutableDictionary;
import com.github.fge.jsonschema.library.syntax.CommonSyntaxCheckerDictionary;
import com.github.fge.jsonschema.syntax.SyntaxChecker;
import com.github.fge.jsonschema.syntax.draftv4.DefinitionsSyntaxChecker;
import com.github.fge.jsonschema.syntax.draftv4.DraftV4DependenciesSyntaxChecker;
import com.github.fge.jsonschema.syntax.draftv4.DraftV4ItemsSyntaxChecker;
import com.github.fge.jsonschema.syntax.draftv4.DraftV4PropertiesSyntaxChecker;
import com.github.fge.jsonschema.syntax.draftv4.DraftV4TypeSyntaxChecker;
import com.github.fge.jsonschema.syntax.draftv4.NotSyntaxChecker;
import com.github.fge.jsonschema.syntax.draftv4.RequiredSyntaxChecker;
import com.github.fge.jsonschema.syntax.helpers.DivisorSyntaxChecker;
import com.github.fge.jsonschema.syntax.helpers.PositiveIntegerSyntaxChecker;
import com.github.fge.jsonschema.syntax.helpers.SchemaArraySyntaxChecker;

public final class DraftV4SyntaxCheckerDictionary {
    private static final Dictionary<SyntaxChecker> DICTIONARY;

    public static Dictionary<SyntaxChecker> get() {
        return DICTIONARY;
    }

    private DraftV4SyntaxCheckerDictionary() {
    }

    static {
        MutableDictionary<SyntaxChecker> dict = MutableDictionary.newInstance();
        dict.addAll(CommonSyntaxCheckerDictionary.get());
        String keyword = "items";
        SyntaxChecker checker = DraftV4ItemsSyntaxChecker.getInstance();
        dict.addEntry(keyword, checker);
        keyword = "multipleOf";
        checker = new DivisorSyntaxChecker(keyword);
        dict.addEntry(keyword, checker);
        keyword = "minProperties";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        dict.addEntry(keyword, checker);
        keyword = "maxProperties";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        dict.addEntry(keyword, checker);
        keyword = "properties";
        checker = DraftV4PropertiesSyntaxChecker.getInstance();
        dict.addEntry(keyword, checker);
        keyword = "required";
        checker = RequiredSyntaxChecker.getInstance();
        dict.addEntry(keyword, checker);
        keyword = "dependencies";
        checker = DraftV4DependenciesSyntaxChecker.getInstance();
        dict.addEntry(keyword, checker);
        keyword = "allOf";
        checker = new SchemaArraySyntaxChecker(keyword);
        dict.addEntry(keyword, checker);
        keyword = "anyOf";
        checker = new SchemaArraySyntaxChecker(keyword);
        dict.addEntry(keyword, checker);
        keyword = "oneOf";
        checker = new SchemaArraySyntaxChecker(keyword);
        dict.addEntry(keyword, checker);
        keyword = "not";
        checker = NotSyntaxChecker.getInstance();
        dict.addEntry(keyword, checker);
        keyword = "definitions";
        checker = DefinitionsSyntaxChecker.getInstance();
        dict.addEntry(keyword, checker);
        keyword = "type";
        checker = DraftV4TypeSyntaxChecker.getInstance();
        dict.addEntry(keyword, checker);
        DICTIONARY = dict.freeze();
    }
}

